/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "poly2d.h"
#include "music.h"
#include "image.h"
#include "smooth.h"
#include "lines.h"
#include "parts.h"
#include "common.h"

const N_FIG=9, N_PHASES=4;

struct Abstract: public Part {
  TPoly2D* fig_phases[N_PHASES][N_FIG];

  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what=0 );
};

void Abstract::Init()
{
  Part::Init();
  for( int j=0; j<N_FIG; j++ ) {
    for( int i=0; i<N_PHASES; i++ ) {
      char str[256];
      sprintf( str, "smthng%d%d.dxf", i+1, j+1 );
      fig_phases[i][j] = new TPoly2D(str);
    }
  }
  part_pal = dither2->palette;
}

void Abstract::Start( int what )
{
  Part::Start();
  ::dither = dither2;
  part_pal = dither2->palette;
}

void fig_line( int y, int x1, int x2, uchar c, PAGE buf )
{
  struct pages { PAGE c, b; };
  pages *foo = (pages*)buf;
  int n = x2-x1+1;
  int offset = y*vidBytesPerLine+x1;
  PAGE p = foo->c+offset;
  for( int x=0; x<n; x++ ) p[x] += c;
//  foo->b[offset] = foo->b[offset+n] = VID_MAX_BRIGHT-1;
}

void Abstract::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);

//  if( what ) {
    vidClearPage(color,30+part_count*3);
//  }

//  if( !what ) return;

  static phase = 0;
  static bool phase_done = true;
  TPoly2D* fig[N_FIG];
  for( i=0; i<N_FIG; i++ ) {
    fig[i] = new TPoly2D( *fig_phases[phase][i] );
  }
  if( part_count ) {
    if( cur_timer < musGetRowTime()*8 ) {
      if( phase_done ) {
	phase = (phase+1) % N_PHASES;
	phase_done = false;
      }
      int steps = 8*musGetRowTime(),
	  step = cur_timer % steps,
	  n1 = (N_PHASES+phase-1) % N_PHASES,
	  n2 = phase;
      for( i=0; i<N_FIG; i++ ) {
	fig[i]->MorphTo( fig_phases[n1][i], fig_phases[n2][i], step, steps );
	fig[i]->Rotate( vidSizeX/2, vidSizeY/2,
			part_count%2 ? step*2*M_PI/steps : -step*2*M_PI/steps );
      }
    }
    else {
/*
      if( cur_timer < musGetRowTime()*16 ) {
	for( i=0; i<N_FIG; i++ ) {
	  fig[i]->Rotate( vidSizeX/2, vidSizeY/2,
	    (cur_timer-musGetRowTime()*8)*2*M_PI/(musGetRowTime()*8) );
	}
      }
*/
      phase_done = true;
    }
  }
  static scale_timer = 0;
  static int old_order = 0;
  static int next_row = 5;
  if( old_order != order ) {
    old_order = order;
    next_row = 7;
  }
  static color_offset = 10;
  switch( what ) {
    case 0: {
      if( row >= next_row ) {
	static bool flag = true;
    //	  if( flag )
	  scale_timer = timer;
	flag = !flag;
	next_row += 12;
	color_offset += 5;
      }
      break;
    }
    case 1: {
      if( row >= next_row ) {
	static bool flag = true;
    //	  if( flag )
	  scale_timer = timer;
	flag = !flag;
	next_row += 6;
	color_offset += 5;
      }
      if( row > 28 ) {
	vidPalette pal;
	int step = cur_timer-musGetRowTime()*23,
	    steps = musGetRowTime()*(63-28);
	float scale_pal = 1-step*0.5/steps;
	for( i=0; i<256; i++ ) {
	  pal[i].r = dither2->palette[i].r*scale_pal;
	  pal[i].g = dither2->palette[i].g*scale_pal;
	  pal[i].b = dither2->palette[i].b*scale_pal;
	}
	vidSetPalette(pal);
      }
      break;
    }
    case 2: {
      if( row >= next_row ) {
	static bool flag = true;
    //	  if( flag )
	  scale_timer = timer;
	flag = !flag;
	next_row += 8;
	color_offset += 5;
      }
      if( row > 28 ) {
	vidPalette pal;
	int step = cur_timer-musGetRowTime()*23,
	    steps = musGetRowTime()*(63-28);
	float scale_pal = 1-step*0.5/steps;
	for( i=0; i<256; i++ ) {
	  pal[i].r = dither2->palette[i].r*scale_pal;
	  pal[i].g = dither2->palette[i].g*scale_pal;
	  pal[i].b = dither2->palette[i].b*scale_pal;
	}
	vidSetPalette(pal);
      }
      break;
    }
  }
  float tmp = 1.3 - (timer-scale_timer)*0.7/sysTimerRes;
  if( tmp < 1 ) tmp = 1;
  for( i=0; i<N_FIG; i++ ) {
    if( part_count ) {
      fig[i]->Scale( vidSizeX/2, vidSizeY/2, tmp, tmp );
    }
    if( part_count || i < cur_timer*N_FIG/32/musGetRowTime() ) {
      struct { PAGE c, b; } foo = { color, bw };
      fig[i]->Draw( fig_line, (color_offset+i*10) % 150, (PAGE)&foo );
      fig[i]->DrawEdges( 0,0, DrawLinePix, bw, VID_MAX_BRIGHT-1 );
      fig[i]->DrawEdges( 0,0, DrawLinePix, color, 255 );
    }
    delete fig[i];
  }
}

Part* partAbstract = new Abstract;
