/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "video.h"
#include "image.h"
#include "sys.h"
#include "lines.h"
#include "smooth.h"
#include "music.h"
#include "parts.h"
#include "common.h"

const ANGLE_TIME = 4*sysTimerRes,
      ALIGN_TIME = 2*sysTimerRes,
      PAL_TIME = 5*sysTimerRes,
      FLASH_TIME = 0.5*sysTimerRes;


class Begin: public Part {
  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what=0 );

  Image *back;
  int direction;
  vidPalette pal;
  int align;
};

void Begin::Init()
{
  Part::Init();
  back = new Image( "back.raw", STRETCH_SCREEN );
  direction = 1;
}

void Begin::Start( int what )
{
  Part::Start();
  direction = -direction;
  ::dither = dither1;

  if( what < 2 ) {
    if( !what ) vidClearPage(bw);
    for( i=0; i<256; i++ ) {
      pal[i].r = pal[i].g = pal[i].b =
	(dither1->palette[i].r + dither1->palette[i].g +
	 dither1->palette[i].b)/3;
    }
    part_pal = pal;
  }
  else {
    part_pal = dither1->palette;
  }
  align = 0;
}

void Begin::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame( color,bw,what );

  int u[4] = { -back->sizeX/2, back->sizeX/2,
	       -back->sizeX/2, back->sizeX/2 };
  int v[4] = { -back->sizeY/2, -back->sizeY/2,
	       back->sizeY/2, back->sizeY/2 };
  for( i=0; i<4; i++ ) {
    float scale = (sin(cur_timer*M_PI/musGetPatternTime())*0.6);
    u[i] *= scale; v[i] *= scale;
    float angle = (float)timer/ANGLE_TIME*2*M_PI * direction;
    int uu = cos(angle)*u[i] + sin(angle)*v[i];
    uu = max(uu,-back->sizeX/2); uu = min(uu,back->sizeX/2-1);
    int vv = cos(angle)*v[i] - sin(angle)*u[i];
    vv = max(vv,-back->sizeY/2); vv = min(vv,back->sizeY/2-1);
    u[i] = uu+back->sizeX/2; v[i] = vv+back->sizeY/2;
  }

/*
  if( what > 1 ) {
    if( cur_timer < FLASH_TIME ) {
      vidPalette tmp_pal;
      vidMorphPalette( pal, dither1->palette, tmp_pal, cur_timer, FLASH_TIME );
      vidSetPalette(tmp_pal);
    }
    else {
      static bool flash = true;
      if( flash ) {
	flash = false;
	vidSetPalette( dither1->palette );
      }
    }
  }
*/

  switch( what ) {

    case 0: {
      vidCopyPage( color, back->data );
      break;
    }

    case 1: {
      if( cur_timer < PAL_TIME ) {
	vidPalette tmp;
	vidMorphPalette( pal, dither1->palette, tmp, cur_timer, PAL_TIME );
	vidSetPalette(tmp);
      }
      else {
	static bool first = false;
	if( first ) {
	  first = true;
	  vidSetPalette(dither1->palette);
	}
      }
      vidCopyPage( color, back->data );
      break;
    }

    case 2: {
      vidCopyPage( color, back->data );
      back->MapToPage2( u[0], v[0], u[1], v[1], u[2], v[2], u[3], v[3],
			color );
      break;
    }

    case 3: {
      int cur_align = cur_timer*VID_AVG_BRIGHT/ALIGN_TIME;
      if( cur_align > align && align < VID_AVG_BRIGHT ) {
	AlignPage( bw, cur_align-align, VID_AVG_BRIGHT );
	align = cur_align;
      }

//	SmoothPage(bw,bw);
      static offset=0;
      back->MapToPage2( u[0], v[0], u[1], v[1], u[2], v[2], u[3], v[3],
			color+offset );
      offset = 1-offset;
      break;
    }
  }
}

Part* partBegin = new Begin;
