/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "common.h"
#include "video.h"

PAGE color, bw;

short* zbuffer;
Image* dither;

Image *dither1, *dither2, *dither3, *dither4,
      *bcar1, *bcar1_bw, *bcar2, *bcar2_bw;

void InitCommon()
{
  color = vidAllocPage();
  bw = vidAllocPage();
//  zbuffer = new short[vidPageSize];
  dither1 = new Image( "dither1.raw", NO_STRETCH );
  int i;
  for( i=0; i<dither1->sizeY*dither1->bytesPerLine; i++ ) {
    if( dither1->data[i] == 0 ) dither1->data[i] = 1;
    if( dither1->data[i] == 255 ) dither1->data[i] = 254;
  }
  dither2 = new Image( "dither2.raw", NO_STRETCH );
  for( i=0; i<dither2->sizeY*dither2->bytesPerLine; i++ ) {
    if( dither2->data[i] == 0 ) dither2->data[i] = 1;
    if( dither2->data[i] == 255 ) dither2->data[i] = 254;
  }
  dither3 = new Image( "dither3.raw", NO_STRETCH );
  for( i=0; i<dither3->sizeY*dither3->bytesPerLine; i++ ) {
    if( dither3->data[i] == 0 ) dither3->data[i] = 1;
    if( dither3->data[i] == 255 ) dither3->data[i] = 254;
  }
  dither4 = new Image( "dither4.raw", NO_STRETCH );
  for( i=0; i<dither4->sizeY*dither4->bytesPerLine; i++ ) {
    if( dither4->data[i] == 0 ) dither4->data[i] = 1;
    if( dither4->data[i] == 255 ) dither4->data[i] = 254;
  }
  dither = dither1;
  bcar1 = new Image( "bcar1.raw", STRETCH_SCREEN );
  bcar2 = new Image( "bcar2.raw", STRETCH_SCREEN );
  bcar1_bw = new Image( "bcar1.raw", STRETCH_SCREEN );
  int n = bcar1_bw->sizeY*bcar1_bw->bytesPerLine;
  for( i=0; i<n; i++ ) bcar1_bw->data[i] >>= 2;
  bcar2_bw = new Image( "bcar2.raw", STRETCH_SCREEN );
  n = bcar2_bw->sizeY*bcar2_bw->bytesPerLine;
  for( i=0; i<n; i++ ) bcar2_bw->data[i] >>= 2;
}
