.486
.model flat

;_text segment para public use32 'code'
_text segment para public use32 'data'

MIN_Z equ -512

extern _phongTable	 :dword

public _shadow
public _colorZGTS
public _bwZGTS
public _zbufferOffsetZGTS
public _textureZGTS
public _lsZGTS
public _zsZGTS
public _tsZGTS
public _x2ZGTS
public _zbuffer0ZGTS
public _zbuffer1ZGTS

public _colorZGT
public _bwZGT
public _textureZGT
public _lsZGT
public _zsZGT
public _tsZGT
public _x2ZGT
public _zbuffer0ZGT
public _zbuffer1ZGT

public _bwZG
public _lsZG
public _zsZG
public _x2ZG
public _zbuffer0ZG
public _zbuffer1ZG

public _bwZP
public _lsZP
public _zsZP
public _x2ZP
public _zbuffer0ZP
public _zbuffer1ZP
public _phongZP

public _textureZPT
public _colorZPT
public _bwZPT
public _x2ZPT
public _lsZPT
public _zsZPT
public _tsZPT
public _phongZPT
public _zbuffer0ZPT
public _zbuffer1ZPT

public _textureSPT
public _colorSPT
public _bwSPT
public _x2SPT
public _lsSPT
public _tsSPT
public _phongSPT

public _textureSGT
public _colorSGT
public _bwSGT
public _x2SGT
public _lsSGT
public _tsSGT

public _bwSP
public _x2SP
public _lsSP
public _phongSP

public DrawLineZGTS_	 ; zbuffer + gouraud + texture + shadow
public DrawLineZGT_	 ; zbuffer + gouraud + texture
public DrawLineZG_	 ; zbuffer + gouraud
public DrawLineZP_	 ; zbuffer + phong
public DrawLineZPT_	 ; zbuffer + phong + texture
public DrawLineSGT_	 ; sort + gouraud + texture
public DrawLineSPT_	 ; sort + phong + texture
public DrawLineSP_	 ; sort + phong

;  DrawLine( x, z, l, t );
;  esi - x
;  edi - z
;  ebx - l
;  eax - u & v

DrawLineZGTS_ proc
       jmp ZGTS_loop
       align 16
ZGTS_loop:
       mov edx,edi
       shr edx,16
ZGTSpatch0:
       cmp dx,[12345678+esi*2]
       jle ZGTSno_draw
ZGTSpatch1:
       mov [12345678+esi*2],ax
ZGTSzbuffer_patch:
       mov dx,[12345678+esi*2]
       cmp dx,MIN_Z
       jnz ZGTSno_shadow
ZGTSshadow_patch:
       mov byte ptr [esi+12345678],60
ZGTSno_shadow:
       mov edx,eax
       shr edx,16
       mov dl,ah
ZGTStexture_patch:
       mov dl,[12345678+edx]
ZGTScolor_patch:
       mov [esi+12345678],dl
ZGTSbw_patch:
       mov [esi+12345678],bh
ZGTSno_draw:
       inc esi
ZGTSx2_patch:
       cmp esi,12345678
       jle ZGTSnext
       jg ZGTSexit
       je ZGTS_loop
ZGTSnext:
ZGTSls_patch:
       add ebx,12345678
ZGTSzs_patch:
       add edi,12345678
ZGTSts_patch:
       add eax,12345678
       jmp ZGTS_loop
ZGTSexit:
       ret
DrawLineZGTS_ endp


DrawLineZGT_ proc
       jmp ZGT_loop
       align 16
ZGT_loop:
       mov edx,edi
       mov ecx,eax
       shr edx,16
ZGTpatch0:
       cmp dx,[12345678+esi*2]
       jle ZGTno_draw
       shr ecx,16
ZGTpatch1:
       mov [12345678+esi*2],dx
       mov cl,ah
ZGTbw_patch:
       mov [esi+12345678],bh
ZGTtexture_patch:
       mov dl,[12345678+ecx]
ZGTcolor_patch:
       mov [esi+12345678],dl
ZGTno_draw:
       inc esi
ZGTx2_patch:
       cmp esi,12345678
       jl ZGTnext
;	je ZGT_loop		  ; what are you lookin' at? get lost...
       jmp ZGTexit
ZGTnext:
ZGTls_patch:
       add ebx,12345678
ZGTzs_patch:
       add edi,12345678
ZGTts_patch:
       add eax,12345678
       jmp ZGT_loop
ZGTexit:
       ret
DrawLineZGT_ endp

DrawLineZG_ proc
ZGpatch:
       jmp ZGloop
       align 16
ZGloop:
       mov edx,edi
       shr edx,16
ZGpatch0:
       cmp dx,[12345678+esi*2]
       jle ZGno_draw
ZGpatch1:
       mov [12345678+esi*2],dx
ZGbw_patch:
       mov [12345678+esi],bh
ZGno_draw:
       inc esi
ZGx2_patch:
       cmp esi,12345678
       jl ZGnext
;	je ZGloop
       jmp ZGexit
ZGnext:
ZGls_patch:
       add ebx,12345678
ZGzs_patch:
       add edi,12345678
       jmp ZGloop
ZGexit:
       ret
DrawLineZG_ endp


DrawLineZP_ proc
ZPpatch:
       jmp ZPloop
       align 16
ZPloop:
       mov edx,edi
       mov ecx,ebx
       shr edx,16
ZPpatch0:
       cmp dx,[12345678+esi*2]
       jle ZPno_draw
       shr ecx,16
ZPpatch1:
       mov [12345678+esi*2],dx
       mov cl,bh
ZPphong_patch:
       mov dl,[12345678+ecx]
ZPbw_patch:
       mov [12345678+esi],dl
ZPno_draw:
       inc esi
ZPx2_patch:
       cmp esi,12345678
       jl ZPnext
;	je ZPloop
       jmp ZPexit
ZPnext:
ZPls_patch:
       add ebx,12345678
ZPzs_patch:
       add edi,12345678
       jmp ZPloop
ZPexit:
       ret
DrawLineZP_ endp

DrawLineZPT_ proc

       jmp ZPTloop
       align 16
ZPTloop:
       mov edx,edi
       shr edx,16
ZPTpatch0:
       cmp dx,[12345678+esi*2]
       jle ZPTno_draw
ZPTpatch1:
       mov [12345678+esi*2],dx
       mov edx,eax
       mov ecx,ebx
       shr edx,16
       shr ecx,16
       mov dl,ah
       mov cl,bh
ZPTtexture_patch:
       mov dl,[12345678+edx]
ZPTphong_patch:
       mov cl,[12345678+ecx]
ZPTcolor_patch:
       mov [esi+12345678],dl
ZPTbw_patch:
       mov [esi+12345678],cl
ZPTno_draw:
       inc esi
ZPTx2_patch:
       cmp esi,12345678
       jl ZPTnext
;	je ZPTloop		 ; what are you lookin' at? get lost...
       jmp ZPTexit
       align 16
ZPTnext:
ZPTts_patch:
       add eax,12345678
ZPTls_patch:
       add ebx,12345678
ZPTzs_patch:
       add edi,12345678
       jmp ZPTloop
ZPTexit:
       ret
DrawLineZPT_ endp

DrawLineSPT_ proc
       jmp SPTloop
       align 16
SPTloop:
       mov ecx,eax
       mov edx,ebx
       shr ecx,16
       shr edx,16
       mov cl,ah
       mov dl,bh
SPTtexture_patch:
       mov cl,[12345678+ecx]
SPTphong_patch:
       mov dl,[12345678+edx]
SPTcolor_patch:
       mov [esi+12345678],cl
SPTbw_patch:
       mov [esi+12345678],dl
       inc esi
SPTx2_patch:
       cmp esi,12345678
       jl SPTnext
;	je SPTloop		 ; what are you lookin' at? get lost...
       jmp SPTexit
       align 16
SPTnext:
SPTls_patch:
       add ebx,12345678
SPTts_patch:
       add eax,12345678
       jmp SPTloop
SPTexit:
       ret
DrawLineSPT_ endp


DrawLineSGT_ proc
       jmp SGTloop
       align 16
SGTloop:
       mov edx,eax
       shr edx,18
       mov dl,ah
SGTtexture_patch:
       mov cl,[12345678+edx]
SGTbw_patch:
       mov [esi+12345678],bh
SGTcolor_patch:
       mov [esi+12345678],cl
       inc esi
SGTx2_patch:
       cmp esi,12345678
       jl SGTnext
       je SGTloop		 ; what are you lookin' at? get lost...
       jmp SGTexit
       align 16
SGTnext:
SGTls_patch:
       add ebx,12345678
SGTts_patch:
       add eax,12345678
       jmp SGTloop
SGTexit:
       ret
DrawLineSGT_ endp

DrawLineSP_ proc
       jmp SPloop
       align 16
SPloop:
       mov edx,ebx
       shr edx,16
       mov dl,bh
SPphong_patch:
       mov dl,[12345678+edx]
SPbw_patch:
       mov [esi+12345678],dl
       inc esi
SPx2_patch:
       cmp esi,12345678
       jl SPnext
;	je SPloop		; what are you lookin' at? get lost...
       jmp SPexit
       align 16
SPnext:
SPls_patch:
       add ebx,12345678
       jmp SPloop
SPexit:
       ret
DrawLineSP_ endp

_textureZGT	   dd ZGTtexture_patch+2
_colorZGT	   dd ZGTcolor_patch+2
_bwZGT		   dd ZGTbw_patch+2
_x2ZGT		   dd ZGTx2_patch+2
_lsZGT		   dd ZGTls_patch+2
_zsZGT		   dd ZGTzs_patch+2
_tsZGT		   dd ZGTts_patch+1
_zbuffer0ZGT	   dd ZGTpatch0+4
_zbuffer1ZGT	   dd ZGTpatch1+4

_textureZPT	   dd ZPTtexture_patch+2
_colorZPT	   dd ZPTcolor_patch+2
_bwZPT		   dd ZPTbw_patch+2
_x2ZPT		   dd ZPTx2_patch+2
_lsZPT		   dd ZPTls_patch+2
_zsZPT		   dd ZPTzs_patch+2
_tsZPT		   dd ZPTts_patch+1
_phongZPT	   dd ZPTphong_patch+2
_zbuffer0ZPT	   dd ZPTpatch0+4
_zbuffer1ZPT	   dd ZPTpatch1+4

_bwSP		   dd SPbw_patch+2
_x2SP		   dd SPx2_patch+2
_lsSP		   dd SPls_patch+2
_phongSP	   dd SPphong_patch+2

_textureSPT	   dd SPTtexture_patch+2
_colorSPT	   dd SPTcolor_patch+2
_bwSPT		   dd SPTbw_patch+2
_x2SPT		   dd SPTx2_patch+2
_lsSPT		   dd SPTls_patch+2
_tsSPT		   dd SPTts_patch+1
_phongSPT	   dd SPTphong_patch+2

_bwZP		   dd ZPbw_patch+2
_x2ZP		   dd ZPx2_patch+2
_lsZP		   dd ZPls_patch+2
_zsZP		   dd ZPzs_patch+2
_zbuffer0ZP	   dd ZPpatch0+4
_zbuffer1ZP	   dd ZPpatch1+4
_phongZP	   dd ZPphong_patch+2

_zbufferOffsetZGTS dd ZGTSzbuffer_patch+4
org ZGTSshadow_patch
    db 2 dup (?)
    _shadow dd ?
org ZGTStexture_patch
    db 3 dup (?)
    _textureZGTS dd ?
org ZGTScolor_patch
    db 2 dup (?)
    _colorZGTS dd ?
org ZGTSbw_patch
    db 2 dup (?)
    _bwZGTS dd ?
org ZGTSx2_patch
    db 2 dup (?)
    _x2ZGTS dd ?
org ZGTSls_patch
    db 2 dup (?)
    _lsZGTS dd ?
org ZGTSzs_patch
    db 2 dup (?)
    _zsZGTS dd ?
org ZGTSts_patch
    db 1 dup (?)
    _tsZGTS dd ?
org ZGTSpatch0
    db 4 dup (?)
    _zbuffer0ZGTS dd ?
org ZGTSpatch1
    db 4 dup (?)
    _zbuffer1ZGTS dd ?

org ZGbw_patch
    db 2 dup (?)
    _bwZG dd ?
org ZGx2_patch
    db 2 dup (?)
    _x2ZG dd ?
org ZGls_patch
    db 2 dup (?)
    _lsZG dd ?
org ZGzs_patch
    db 2 dup (?)
    _zsZG dd ?
org ZGpatch0
    db 4 dup (?)
    _zbuffer0ZG dd ?
org ZGpatch1
    db 4 dup (?)
    _zbuffer1ZG dd ?

org SGTtexture_patch
    db 2 dup (?)
    _textureSGT dd ?
org SGTcolor_patch
    db 2 dup (?)
    _colorSGT dd ?
org SGTbw_patch
    db 2 dup (?)
    _bwSGT dd ?
org SGTx2_patch
    db 2 dup (?)
    _x2SGT dd ?
org SGTls_patch
    db 2 dup (?)
    _lsSGT dd ?
org SGTts_patch
    db 1 dup (?)
    _tsSGT dd ?

_text ends

end
