/*

Name:
DRV_SDL.C

Description:
Experimental Mikmod driver for output using the Simple DirectMedia Layer

Method:
Single buffer, automatic refill using a high-resolution timer callback routine.
This one is probably the best.

Portability:
Any platform supported by SDL

*/
#include <stdio.h>
#include "mikmod.h"

#include "SDL_audio.h"
#include "SDL_byteorder.h"


static int swap_endian;

BOOL SDRV_IsThere(void)
{
	return 1;
}

void FillAudio(void *userdata, Uint8 *stream, int len)
{
	VC_WriteBytes(stream, len);
}

BOOL SDRV_Init(void)
{
	SDL_AudioSpec spec;
	const SDL_AudioSpec *newspec;

	spec.freq = md_mixfreq;
	if( md_mode & DMODE_16BITS ) {
		if ( SDL_BYTEORDER == SDL_BIG_ENDIAN ) {
			spec.format = AUDIO_S16MSB;
		} else {
			spec.format = AUDIO_S16LSB;
		}
	} else {
		spec.format = AUDIO_U8;
	}
	if( md_mode & DMODE_STEREO ) {
		spec.channels = 2;
	} else {
		spec.channels = 1;
	}
	spec.samples = 4096;
	spec.callback = FillAudio;
	spec.userdata = NULL;

	if ( SDL_OpenAudio(&spec, NULL) < 0 ) {
		return 0;
	}
	if(!VC_Init()){
		SDL_CloseAudio();
		return 0;
	}

	return 1;
}


void SDRV_Exit(void)
{
	SDL_CloseAudio();
	VC_Exit();
}


void SDRV_PlayStart(void)
{
	VC_PlayStart();
	SDL_PauseAudio(0);
}


void SDRV_PlayStop(void)
{
	SDL_PauseAudio(1);
	VC_PlayStop();
}


void SDRV_Update(void)
{
	/* does nothing, buffers are updated in the background */
}


DRIVER drv_sdl={
	NULL,
	"SDL",
	"MikMod SDL Driver v1.0",
	SDRV_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	SDRV_Init,
	SDRV_Exit,
	SDRV_PlayStart,
	SDRV_PlayStop,
	SDRV_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay
};

