/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "misc.h"
#include "music.h"
#include "video.h"
#include "sys.h"
#include "resource.h"

CompareFunc* _compare;

int TCollection_Compare( const void* _1, const void* _2 )
{
  return _compare( *(void**)_1, *(void**)_2 );
}

Parser::Parser( char* name ): n(0), eof(false)
{
  buf = (char*)resGetResource( name, &size );
}

Parser::~Parser()
{
  resFreeResource(buf);
}

char Parser::getChar()
{
  if( n<size ) {
    return buf[n++];
  }
  else {
    eof = true;
    return 0;
  }
}

char* Parser::getToken( const char* delimiters )
{
  static char buf[1024];
  bool quote = false;
  char* ptr = buf;
  do {
    if( !(*ptr = getChar()) ) return 0;
    if( *ptr == '\"' ) {
      quote = true;
      ptr--;
    }
  } while ( strchr( delimiters, *ptr ) && !quote );
  do {
    if( !(*(++ptr) = getChar()) ) return 0;
    if( *ptr == '\"' && quote ) break;
  } while( (quote || !strchr( delimiters, *ptr )) && (ptr-buf)<1023 );
  *ptr = 0;
  return buf;
}
