/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __MISC__
#define __MISC__

#define PROJECT_NAME	"qrash"

typedef unsigned char	uchar;
typedef unsigned short	ushort;
typedef unsigned int	uint;
typedef unsigned long	ulong;
typedef unsigned char	uchar;
typedef unsigned short	ushort;
typedef unsigned int	uint;
typedef unsigned long	ulong;

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "video.h"
#include "sys.h"

#ifndef M_PI
#define M_PI	3.141592653589
#endif

#ifndef max
# define max(a,b)  (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
# define min(a,b)  (((a) < (b)) ? (a) : (b))
#endif

#define sqr(x)	((x)*(x))

#define ALLOC_STEP 100

template <class T>
class TCollection {
  int allocated;
  bool autoDelete;
public:
  T** Items;
  int Count;
  TCollection( bool AutoDelete = true ):
    Count(0), allocated(0), Items(0), autoDelete(AutoDelete) {}
  TCollection(TCollection& t) {
    Count = t.Count;
    allocated = t.allocated;
    Items = (T**)cmalloc( sizeof(T*)*allocated );
    memcpy( Items, t.Items, sizeof(T*)*Count );
  }
  void Insert( T* );
  void Delete(int index);
  void Delete(T* item) { Delete(IndexOf(item)); };
  void PackDelete(int index);
  void PackDelete(T* item) { PackDelete(IndexOf(item)); };
  void Free(int index)
  {
    if( autoDelete ) delete Items[index];
    Delete(index);
  }
  void Free(T* item) { Free(IndexOf(item)); }
  void DeleteAll() { Count = 0; }
  void FreeAll();
  T* At(int index)
  { return Items[index]; }
  T* operator[]( int index ) { return At(index); }
  int IndexOf(T*);
  void Sort( int (*compare)(const T*, const T*) );
  void Pack();
  ~TCollection() {
    if( autoDelete ) FreeAll();
    DeleteAll();
    cfree(Items);
  }
};

int TCollection_Compare( const void*, const void* );
typedef int CompareFunc(const void*, const void*);
extern CompareFunc* _compare;

template <class T>
void TCollection<T>::Sort( int (*compare)(const T*, const T*) )
{
  _compare = (CompareFunc*)compare;
  qsort( Items, Count, sizeof(void*), TCollection_Compare );
}

template <class T>
void TCollection<T>::Insert( T* item )
{
  if( ++Count > allocated ) {
    allocated += ALLOC_STEP;
    T** tmp = Items;
    Items = (T**) cmalloc( sizeof(T*)*allocated );
    if( tmp ) {
      memcpy( Items, tmp, sizeof(T*)*(allocated-ALLOC_STEP) );
      cfree(tmp);
    }
  }
  Items[Count-1] = item;
}

template <class T>
void TCollection<T>::Delete(int index)
{
  if( index>=0 ) Items[index]=0;
}

template <class T>
void TCollection<T>::PackDelete(int index)
{
  if( index>=0 ) {
    memcpy( &Items[index], &Items[index+1], sizeof(T*)*(allocated-index-1) );
    Count--;
  }
}

template <class T>
int TCollection<T>::IndexOf( T* item )
{
  for( int i=0; i<Count; i++ ) {
    if( item == Items[i] ) return i;
  }
  if(item) {
    error( "TCollection::IndexOf failed" );
  }
  return -1;
}

template <class T>
void TCollection<T>::Pack()
{
  int i;
  while( (i=IndexOf(0)) != -1 ) PackDelete(i);
}

template <class T>
void TCollection<T>::FreeAll()
{
  for( int i=0; i<Count; i++ ) {
    Free(i);
  }
  DeleteAll();
}

struct Parser {
  Parser( char* name );
  ~Parser();
  char* getToken( const char* delimiters );
  bool eof;
  void restart() { n=0; }
private:
  char getChar();
  int n, size;
  char* buf;
};

#endif
