/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#if !defined(DOS) && !defined(OS2) && !defined(W32) && !defined(SDL)
#define FORK_NEEDED
#include <sys/time.h>
#include <signal.h>
#else
#if defined(W32) || defined(OS2)
#include <process.h>
#ifdef W32
#include <windows.h>
#endif
#endif
#ifdef DOS
#include <dos.h>
#endif
#endif
#ifdef SDL
// Needed for nosound updates
#include "SDL_thread.h"
#include "SDL_timer.h"
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include "music.h"
#include "misc.h"
#include "resource.h"
#include "mikmod/mikmod.h"

#define SampleChannels 8

bool musInitialized = false, musPlaying = false;
UNIMOD* musModule;
int ModChannels;
bool musNoSound = false;

bool mus_kb_handler( KB key )
{
  switch( key ) {
    case KB_PLUS: {
      if( musGetVolume() <= 90 )
	musSetVolume( musGetVolume()+10 );
      else
	musSetVolume(100);
      return true;
    }
    case KB_MINUS: {
      if( musGetVolume() > 10 )
	  musSetVolume( musGetVolume()-10 );
      else
	musSetVolume(0);
      return true;
    }
  }
  return false;
}

static void tickhandler(void)
{
	MP_HandleTick();    /* play 1 tick of the module */
	MD_SetBPM(mp_bpm);
}

void musInitMusic(void) {
  md_mixfreq	  = 22000;		       /* standard mixing freq */
  md_dmabufsize   = 16384;		       /* standard dma buf size */
  md_mode	  = DMODE_16BITS|DMODE_STEREO; /* standard mixing mode */

/*
  ML_RegisterLoader(&load_m15);
  ML_RegisterLoader(&load_mod);
  ML_RegisterLoader(&load_mtm);
  ML_RegisterLoader(&load_stm);
  ML_RegisterLoader(&load_ult);
  ML_RegisterLoader(&load_uni);
*/
  ML_RegisterLoader(&load_s3m);
  ML_RegisterLoader(&load_xm);

  MD_RegisterDriver(&drv_nos); // _must_ be the first registred driver
  MD_RegisterPlayer(tickhandler);

  sysRegisterKeyboardHandler( &mus_kb_handler );

  musSystemInit();
}

UNIMOD* musLoadModule(char* name) {
  FILE* fp = resOpenFile(name);
  if( !(musModule=ML_LoadFP(fp)) ) error("Cannot load module");
  resClose(fp);
  MP_Init(musModule);
  ModChannels = musModule->numchn;
  md_numchn = ModChannels + SampleChannels;
  return musModule;
}

#if defined(OS2) || defined (W32) || defined(SDL)

int update_thread( void* foo )
{
  while(true) {
#ifdef SDL
    SDL_Delay(50);
#else
    delay(50);
#endif
    MD_Update();
  }
  return(0);
}

#endif

enum {
  SET_VOLUME,
  GET_VOLUME,
  SET_POS,
  GET_POS,
  GET_ROWTIME
};

static int player_pid = 0;
static int pipes[2][2];

void musStartMusic() {

  musSetVolume(100);
  if( musPlaying) musStopMusic();
  musPlaying = true;

#ifdef FORK_NEEDED
  pipe( pipes[0] );
  pipe( pipes[1] );
  player_pid = fork();
  if( !player_pid ) {
    MD_PlayStart();
    while( true ) {
      fd_set fds;
      FD_ZERO(&fds);
      FD_SET(pipes[0][0],&fds);
      struct timeval tv = { 0, 50000 };
      if( select( pipes[0][0]+1, &fds, 0, 0, &tv ) > 0 ) {
	int command;
	read( pipes[0][0], &command, sizeof(int) );
	switch(command) {
	  case SET_VOLUME: {
	    read( pipes[0][0], &command, sizeof(int) );
	    musSetVolume(command);
	    break;
	  }
	  case GET_VOLUME: {
	    command = musGetVolume();
	    write( pipes[1][1], &command, sizeof(int) );
	    break;
	  }
	  case SET_POS: {
	    int pos[2];
	    read( pipes[0][0], &pos[0], sizeof(int) );
	    read( pipes[0][0], &pos[1], sizeof(int) );
	    musSetPosition( pos[0], pos[1] );
	    break;
	  }
	  case GET_POS: {
	    int pos[2];
	    musGetPosition( &pos[0], &pos[1] );
	    write( pipes[1][1], &pos[0], sizeof(int) );
	    write( pipes[1][1], &pos[1], sizeof(int) );
	    break;
	  }
	  case GET_ROWTIME: {
	    command = musGetRowTime();
	    write( pipes[1][1], &command, sizeof(int) );
	    break;
	  }
	}
      }
      MD_Update();
    }
  }
#else

  MD_PlayStart();

#ifdef OS2
  _beginthread( update_thread, malloc(16384), 16384, 0 );
#endif

#ifdef W32
  _beginthread( update_thread, 16384, 0 );
#endif

#endif
}

void musStopMusic() {
  if( musPlaying ) {
#ifdef FORK_NEEDED
    kill( player_pid, SIGKILL );
#else
    MD_PlayStop();
#endif
    ML_Free(musModule);
    musPlaying = false;
  }
}

void musLoadConfig( char* filename ) {
  FILE *h = fopen( filename, "rb" );
  fread( &md_device, sizeof(md_device), 1, h );
  fread( &md_mixfreq, sizeof(md_mixfreq), 1, h );
  fread( &md_mode, sizeof(md_mode), 1, h );
  fclose(h);
}

void musSaveConfig( char* filename ) {
  FILE *h = fopen( filename, "wb" );
  fwrite( &md_device, sizeof(md_device), 1, h );
  fwrite( &md_mixfreq, sizeof(md_mixfreq), 1, h );
  fwrite( &md_mode, sizeof(md_mode), 1, h );
  fclose(h);
}

SAMPLE* musLoadSample( char* name ) {
  FILE* fp = resOpenFile(name);
  return MW_LoadWavFP(fp);
}

void musPlaySample( SAMPLE* s, uchar volume, uchar panning, int frequency ) {
  static int CurChannel = ModChannels;
  MD_VoiceSetVolume(CurChannel,volume%64);
  MD_VoiceSetPanning(CurChannel,panning);
  MD_VoiceSetFrequency(CurChannel,frequency);
  MD_VoicePlay(CurChannel,s->handle,0,s->length,0,0,s->flags);
  CurChannel++;
  if( CurChannel >= ModChannels+SampleChannels )
    CurChannel = ModChannels;
}

void musFreeSample( SAMPLE* s ) {
  MW_FreeWav(s);
}

void musSetVolume( int vol )
{
  if( player_pid ) {
    int command = SET_VOLUME;
    write( pipes[0][1], &command, sizeof(int) );
    write( pipes[0][1], &vol, sizeof(int) );
  }
  else {
    mp_volume = vol;
  }
}

int musGetVolume()
{
  if( player_pid ) {
    int command = GET_VOLUME;
    write( pipes[0][1], &command, sizeof(int) );
    int vol;
    read( pipes[1][0], &vol, sizeof(int) );
    return vol;
  }
  else {
    return mp_volume;
  }
}

void musGetPosition( int* order, int* row )
{
  if( player_pid ) {
    int command = GET_POS;
    write( pipes[0][1], &command, sizeof(int) );
    int pos[2];
    read( pipes[1][0], &pos[0], sizeof(int) );
    read( pipes[1][0], &pos[1], sizeof(int) );
    if(order) *order = pos[0];
    if(row) *row = pos[1];
  }
  else {
    if(order) *order = mp_sngpos;
    if(row) *row = mp_patpos;
  }
}

extern "C" int forbid;

void musSetPosition( int order, int row )
{
  if( player_pid ) {
    int command = SET_POS;
    write( pipes[0][1], &command, sizeof(int) );
    write( pipes[0][1], &order, sizeof(int) );
    write( pipes[0][1], &row, sizeof(int) );
  }
  else {
    forbid = 1;
    if( order != - 1 ) mp_sngpos = order;
    if( row != -1 ) mp_patpos = row;
    forbid = 0;
  }
}

int
musGetRowTime()
{
  if( player_pid ) {
    int command = GET_ROWTIME;
    write( pipes[0][1], &command, sizeof(int) );
    int row_time;
    read( pipes[1][0], &row_time, sizeof(int) );
    return row_time;
  }
  else {
    return sysTimerRes*125*mp_sngspd/(50*mp_bpm);
  }
}

void
musSystemInit(void) {

//	MD_RegisterDriver(&drv_raw);

#ifdef SUN
	MD_RegisterDriver(&drv_sun);
#elif defined(SOLARIS)
	MD_RegisterDriver(&drv_sun);
#elif defined(ALPHA)
	MD_RegisterDriver(&drv_AF);
#elif defined(LINUX)
	MD_RegisterDriver(&drv_vox);
#elif defined(ULTRA)
	MD_RegisterDriver(&drv_ultra);
#elif defined(HPUX)
	MD_RegisterDriver(&drv_hp);
#elif defined(AIX)
	MD_RegisterDriver(&drv_aix);
#elif defined(SGI)
	MD_RegisterDriver(&drv_sgi);
#elif defined(DOS)
	MD_RegisterDriver(&drv_ss);
	MD_RegisterDriver(&drv_sb);
	MD_RegisterDriver(&drv_gus);
#elif defined(SDL)
	MD_RegisterDriver(&drv_sdl);
#elif defined(OS2)
	MD_RegisterDriver(&drv_os2);
#elif defined(W32)
	MD_RegisterDriver(&drv_w95);
//	  MD_RegisterDriver(&drv_ds);
#endif

}

#if defined(__WATCOMC__) && defined(DOS)

#include <dos.h>
void __interrupt __far (*old8) ();
void __interrupt __far timer_proc() {
  MD_Update();
  _chain_intr(old8);
}

#endif

#ifdef __DJGPP__

#include <go32.h>
#include <dpmi.h>
__dpmi_paddr old8;

#endif

extern "C" DRIVER* firstdriver;

void
musInitCard() {

  if( musNoSound || ( !musNoSound && !MD_Init()) ) {

    if( !musNoSound ) {
      vidMessage( "sound initialization failed, falling back to no sound" );
    }

    md_driver=firstdriver;
    int t;
    for( t=1; md_driver != NULL && md_driver != &drv_nos; t++ ) {
      md_driver=md_driver->next;
    }
    if( !md_driver ) {
      char str[256];
      sprintf( str, "Cannot initialize sound system for device #%d \n(%s)",
	       md_device, myerr );
      error(str);
    }
    else {
      md_device = t;
      if( !MD_Init() ) {
	error( "shit happens, even no sound driver doesn't work" );
      }
#ifdef SDL
      SDL_CreateThread(update_thread, NULL);
#endif
    }
  }
#if defined(__WATCOMC__) && defined(DOS)
  old8 = _dos_getvect( 8 );
  _dos_setvect( 8, timer_proc );
#endif
#ifdef __DJGPP__
  __dpmi_get_protected_mode_interrupt_vector( 8, &old8 );
  _go32_dpmi_seginfo new8;
  new8.pm_offset = (unsigned long)&MD_Update;
  _go32_dpmi_chain_protected_mode_interrupt_vector( 8, &new8 );
#endif
  musInitialized = true;
}

void
musCloseMusic() {
  if( musInitialized ) {
#if defined(__WATCOMC__) && defined(DOS)
    _dos_setvect( 8, old8 );
#endif
#ifdef __DJGPP__
    __dpmi_set_protected_mode_interrupt_vector( 8, &old8 );
#endif
    MD_Exit();
  }
}

void
musChooseCard() {
  if( musNoSound ) return;
#if defined(OS2) || defined(W32) || defined(SDL)
  md_device = 0; // autodetect only
  return;
#endif
  puts( "Choose sound device :\n" );
#ifdef DOS
  puts( "0) Autodetect (enviroment variable has to be set)" );
#endif
  MD_InfoDriver();
  md_device = sysGetNumber( "\nType corresponding number : ",0,99 );

#if !defined(DOS) && !defined(OS2) && !defined(W32) && !defined(SDL)

  //  if( md_device != 1 ) {
    switch(sysGetNumber("\nChoose output mode:\n\n"
			 "1. 8 bits, mono\n"
			 "2. 8 bits, stereo\n"
			 "3. 16 bits, mono\n"
			 "4. 16 bits, stereo\n"
			 "\nType corresponding number : ",1,4)) {
    case 1:
      md_mode=0; break;
    case 2:
      md_mode=DMODE_STEREO; break;
    case 3:
      md_mode=DMODE_16BITS; break;
    case 4:
      md_mode=DMODE_16BITS|DMODE_STEREO; break;
    }
//    md_mode|=DMODE_INTERP;
    //	}
#endif
}
