/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __POLY2D__
#define __POLY2D__

#include "misc.h"
#include "video.h"

class TPoint2D;
typedef TPoint2D* PPoint2D;

struct TPoint2D {
  int X,Y;
  TPoint2D( int AX, int AY ): X(AX), Y(AY) {}
//  virtual void Draw( PAGE Buffer );
  void Move( int DX, int DY ) { X += DX<<16; Y += DY<<16; };
  void Rotate( int CX, int CY, float R );
  void Scale( int CX, int CY, float RX, float RY );
  void MorphTo( PPoint2D Point1, PPoint2D Point2, int NStep, int NSteps );
};

struct TEdge {
  PPoint2D A,B;
  int CurX, Step;
  TEdge( PPoint2D A_, PPoint2D B_ ): A(A_), B(B_) {};
  void PrepareToDraw();
};
typedef TEdge* PEdge;

typedef void (*PFLineDraw)( int Y, int X1, int X2, uchar Color, PAGE Buffer );

class TPoly2D;
typedef TPoly2D* PPoly2D;

typedef void (EdgeDrawProc)(PAGE,int,int,int,int,uchar);

class TPoly2D: public TPoint2D {
  void GetNextPoint(Parser& fp);
  void GetNextEdge(Parser& fp);
public:
  TPoint2D Min,Max;
  int SizeX() { return (Max.X-Min.X)>>16; }
  int SizeY() { return (Max.Y-Min.Y)>>16; }
  TCollection<TPoint2D> Points;
  TCollection<TEdge> Edges;
  TPoly2D():
    TPoint2D(0,0), Edges(), Points(), Min(0,0), Max(0,0) {};
  TPoly2D( TPoly2D& Poly );
  TPoly2D( char* Name );
  void LoadDXF(Parser& fp);
  virtual void Draw( PFLineDraw APLine, uchar AColor, PAGE Buffer );
  void DrawEdges( int x, int y, EdgeDrawProc p, PAGE page, uchar Color );
  void Move( int DX, int DY );
  void MoveTo( PPoly2D Poly, int DX, int DY );
  void Rotate( int CX, int CY, float R );
  void RotateTo( PPoly2D Poly, int CX, int CY, float R );
  void Scale( int CX, int CY, float RX, float RY );
  void ScaleTo( PPoly2D Poly, int CX, int CY, float RX, float RY );
  void MorphTo( PPoly2D Poly1, PPoly2D Poly2, int NStep, int NSteps );
  void Clear();
  virtual ~TPoly2D();
};

#endif
