/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#define ZLIB

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include "resource.h"
#include "misc.h"
#include "mikmod/mikmod.h"
#ifdef ZLIB
#include <zlib.h>
#endif

struct entry {
  char name[16];
  int offset, size;
} *table=0;

char resource_name[256];
int resource_number=0;
int current=-1;

char* my_strlwr( char* str )
{
  static char foo[256];
  int i;
  for( i=0; str[i]; i++ ) {
    foo[i] = tolower(str[i]);
  }
  foo[i] = 0;
  return foo;
}
int read_int( FILE* f )
{
  int d1 = fgetc(f),
      d2 = fgetc(f),
      d3 = fgetc(f),
      d4 = fgetc(f);
  return (d4<<24)|(d3<<16)|(d2<<8)|d1;
}

void resInit( char* name )
{
  strcpy( resource_name, my_strlwr(name) );
  FILE* f = fopen( resource_name, "rb" );
  if(f) {
    fseek( f, -4, SEEK_END );
    int n;
    n = read_int(f);
    if( n == 0x12345678 ) {
      fseek( f, -8, SEEK_END );
      n = read_int(f);
      fseek( f, n, SEEK_SET );
      resource_number = read_int(f);
      table = (entry*)cmalloc(sizeof(entry)*resource_number);
      for( int i=0; i<resource_number; i++ ) {
	fread( table[i].name, sizeof(table[i].name), 1, f );
	table[i].offset = read_int(f);
	table[i].size = read_int(f);
      }
    }
    fclose(f);
  }
}

FILE* fp=0;


FILE* resOpenFile( char* name )
{
  current=-1;
  fp = fopen( name, "rb" );
  if(!fp) {
    for( current=0; current<resource_number; current++ ) {
      if( !strcmp( my_strlwr(name), table[current].name ) ) {
	fp = fopen( resource_name, "rb" );
	fseek( fp, table[current].offset, SEEK_SET );
	_mm_setiobase( table[current].offset );
	return fp;
      }
    }
    char str[256];
    sprintf( str, "Cannot open resource '%s'", name );
    error(str);
  }
  _mm_setiobase(0);
//  const N = 4096;
///  static char buf[N];
//  setvbuf( fp, buf, _IOFBF, N );
  return fp;
}

void* resGetResource( char* name, int* file_size )
{
  FILE* fp = resOpenFile(name);
  int size = resFileSize(fp);
  uchar* tmp = (uchar*)cmalloc(size);
#ifdef ZLIB
  int foo = dup( fileno(fp) );
  lseek( foo, ftell(fp), SEEK_SET );
  gzFile gzf = gzdopen( foo, "rb" );
  if( !gzf ) error( "cannot open gzipped file" );
  if( gzread( gzf, tmp, size ) == -1 )
    error( "cannot read gzipped file" );
  gzclose(gzf);
#else
  fread( tmp, size, 1, fp );
#endif
  resClose(fp);
  if( !strcmp( (char*)tmp, "RLE" ) ) {
    int newsize = tmp[4]+(tmp[5]<<8)+(tmp[6]<<16)+(tmp[7]<<24);
    uchar* outbuf=(uchar*)cmalloc(newsize);
    int i,j;
    for( i=8,j=0; i<size; i++ ) {
      if( tmp[i] > 0x80 ) {
	for( int k=0; k<(tmp[i]&0x7F); k++ ) {
	  outbuf[j++] = tmp[i+1];
	}
	i++;
      }
      else {
	outbuf[j++]=tmp[i];
      }
    }
    if( j != newsize ) {
      char str[256];
      sprintf( str, "RLE decoding error (%s)", name );
      error(str);
    }
    cfree(tmp);
    tmp = outbuf;
  }
  if( file_size ) *file_size = size;
  return tmp;
}

void resFreeResource( void* ptr )
{
  cfree(ptr);
}

bool resEof( FILE* fp )
{
  if( current == -1 ) {
    return feof(fp);
  }
  else {
    int pos = ftell(fp);
    return( feof(fp) ||
	    ftell(fp) > table[current].offset+table[current].size );
  }
}

void resClose( FILE* fp )
{
  fclose(fp);
}

int resFileSize( FILE* fp )
{
  if( current == -1 ) {
    long pos = ftell(fp);
    fseek(fp,0,SEEK_END);
    int size = ftell(fp);
    fseek(fp,pos,SEEK_SET);
    return size;
  }
  else {
    return table[current].size;
  }
}
