/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __SYS__
#define __SYS__

#include "misc.h"

#ifndef O_BINARY
#define O_BINARY 0
#endif

extern bool sysDebug;

#define sysTimerRes    1000.0

enum KB {
  KB_NONE,
  KB_PLUS,
  KB_MINUS,
  KB_F11,
  KB_ESC,
  KB_NEXT
};

typedef bool KBHandler( KB key );

// portable
extern int sysVideoMode;

void error( char* );

void* cmalloc( size_t size );
void cfree( void* ptr );

void sysSaveConfig( char* filename );
bool sysLoadConfig( char* filename );
void sysRegisterKeyboardHandler( KBHandler* handler );
void sysUpdateFrame();	// should be called once per frame or so
			// vidShowPage did it already

void Startup( char* cmdline );
void Shutdown();
uint sysTimer();
void sysResetTimer();
void sysMain( int argc, char* argv[] );
int sysGetNumber( char* str, int min, int max );

// system dependent
void sysStartup();
void sysCleanup();
uint sysCurrentTime();
KB sysGetKey(); // 0 - if no key pressed

#endif
