/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>
#include <time.h>
#include "misc.h"
#include "music.h"
#include "video.h"
#include "resource.h"
#include "svgakit/ztimer.h"
#ifdef __DJGPP__
#include <crt0.h>
#include <sys/nearptr.h>
#endif

#ifdef __DJGPP__
int _crt0_startup_flags = _CRT0_FLAG_LOCK_MEMORY |
			  _CRT0_FLAG_NEARPTR |
			  _CRT0_FLAG_NONMOVE_SBRK;
#endif

void sysStartup()
{
#ifdef __DJGPP__
  __djgpp_nearptr_enable();
#endif
  puts( PROJECT_NAME". (c)97 Queue Members Group Art Division\n" );
  ZTimerInit();
  LZTimerOn();
}

extern size_t allocated, max_alloc;

void sysCleanup()
{
  LZTimerOff();
  while( kbhit() ) getch();
  if( sysDebug )
    printf( "Memory allocated: now=%d, max=%d\n", allocated, max_alloc );
  exit(0);
}

uint sysCurrentTime()
{
  return LZTimerLap()*sysTimerRes*LZTIMER_RES;
//  return clock()*sysTimerRes/CLOCKS_PER_SEC;
}

KB sysGetKey()
{
/*
#ifdef __WATCOMC__
  sysDebug = *(uchar*)(0x417) & 3;
#endif
#ifdef __DJGPP__
  sysDebug = *(uchar*)(__djgpp_conventional_base+0x417) & 3;
#endif
*/
  if( kbhit() ) {
    switch( getch() ) {
      case '+': return KB_PLUS;
      case '-': return KB_MINUS;
      case 133: return KB_F11;
      case 27:	return KB_ESC;
    }
  }
  return KB_NONE;
}

char cmdline[2048] = "";

void main( int argc, char* argv[] )
{
  for( int i=1; i<argc; i++ ) {
    strcat( cmdline, argv[i] );
  }
  Startup( cmdline );
  sysMain( argc, argv );
  Shutdown();
}
