/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SDL.h"
#include "sys.h"

void sysStartup()
{
  if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) {
    fprintf(stderr, "Couldn't initialize SDL: %s\n", SDL_GetError());
    exit(1);
  }
  puts( "\n"PROJECT_NAME". (c)97 Queue Members Group Art Division\n" );
  sysResetTimer();
}

void sysCleanup()
{
  SDL_Quit();
  exit(0);
}

uint
sysCurrentTime()
{
  return SDL_GetTicks();
}

char cmdline[2048] = "";

int main( int argc, char* argv[] )
{
  for( int i=1; i<argc; i++ ) {
    strcat( cmdline, argv[i] );
  }
  Startup( cmdline );
  sysMain( argc, argv );
  Shutdown();
}
