/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <zlib.h>

struct entry {
  char name[16];
  int offset, size;
} *table=0;

void main( int argc, char* argv[] )
{
  int f = open( argv[1], O_RDONLY );
  if(f) {
    lseek( f, -4, SEEK_END );
    int n;
    read( f, &n, sizeof(int) );
    if( n == 0x12345678 ) {
      lseek( f, -8, SEEK_END );
      read( f, &n, sizeof(int) );
      lseek( f, n, SEEK_SET );
      int resource_number;
      read( f, &resource_number, sizeof(int) );
      table = (entry*)malloc(sizeof(entry)*resource_number);
      read( f, table, sizeof(entry)*resource_number );
      for( int i=0; i<resource_number; i++ ) {
	printf( "name=%s offset=%d size=%d\n",
		table[i].name, table[i].offset, table[i].size );
	FILE* f1 = fopen( table[i].name, "wb" );
	void* buf = malloc( table[i].size );
	lseek( f, table[i].offset, SEEK_SET );
	gzFile gzf = gzdopen( dup(f), "rb" );
	gzread( gzf, buf, table[i].size );
	gzclose(gzf);
	fwrite( buf, 1, table[i].size, f1 );
	free(buf);
	fclose(f1);
      }
    }
    close(f);
  }
}
