/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <ctype.h>
#include <conio.h>
#include "svgakit/svga.h"
#include "svgakit/vesavbe.h"
#include "video.h"
#include "misc.h"
#include "music.h"
#include "image.h"

#define SVGA

SV_devCtx* dc;
PAGE vidVideoMemory;
bool useVirtualBuffer = false;
int vidPageStep;
ulong conventional_base = 0;

#ifdef __WATCOMC__
  #include <i86.h>
#endif

#ifdef __DJGPP__
  #include <go32.h>
  #include <dos.h>
  #include <dpmi.h>
  #include <sys/nearptr.h>
#endif

enum { vidMode13, vidModeX, vidModeLinear, vidModeBanked } vidModeType;
bool PageAllocated[16] = {false};

#define SC_INDEX	0x3C4
#define MISC_OUTPUT	0x3C2
#define CRTC_INDEX	0x3D4
#define CHAIN4_OFF	0x604
#define ASYNC_RESET	0x100
#define SEQU_RESTART	0x300

enum {
  X320x200=1,
  X320x400,
  X360x200,
  X360x400,
  X320x240,
  X320x480,
  X360x240,
  X360x480,
  XMaxMode
} XModeNum;

uint W320[] = { 0x5F00, 0x4F01, 0x5002, 0x8203, 0x5404, 0x8005 };
uint W360[] = { 0x6B00, 0x5901, 0x5A02, 0x8E03, 0x5E04, 0x8A05 };

uint H200[] = { 0xBF06, 0x1F07, 0x9C10, 0x8E11, 0x8F12, 0x9615, 0xB916, 0x4109, 0x0014, 0xE317 };
uint H240[] = { 0x0D06, 0x3E07, 0xEA10, 0x8C11, 0xDF12, 0xE715, 0x0616, 0x4109, 0x0014, 0xE317 };
uint H400[] = { 0xBF06, 0x1F07, 0x9C10, 0x8E11, 0x8F12, 0x9615, 0xB916, 0x4009, 0x0014, 0xE317 };
uint H480[] = { 0x0D06, 0x3E07, 0xEA10, 0x8C11, 0xDF12, 0xE715, 0x0616, 0x4009, 0x0014, 0xE317 };

struct XMode {
  int x, y;
  uchar clock;
  int pagenum;
  uint* W;
  uint* H;
}

XModes[XMaxMode] = {
  { 0,	 0,   0,    0, 0,    0	},
  { 320, 200, 0x63, 4, W320, H200 },
  { 320, 400, 0x63, 2, W320, H400 },
  { 360, 200, 0x67, 3, W360, H200 },
  { 360, 400, 0x67, 1, W360, H400 },
  { 320, 240, 0xE3, 3, W320, H240 },
  { 320, 480, 0xE3, 1, W320, H480 },
  { 360, 240, 0xE7, 2, W360, H240 },
  { 360, 480, 0xE7, 1, W360, H480 },
};

XMode* XCurrentMode;
int XCurrentPage=1;
int bank_size, bank_granularity;
PAGE current_page, flip_page1, flip_page2;

PAGE vidAllocScreenPage()
{
  if( vidModeType == vidModeLinear ) {
    for( int i=0; i<vidMaxPage; i++ ) {
      if( !PageAllocated[i] ) {
	PageAllocated[i] = true;
	return vidVideoMemory+vidPageSize*i;
      }
    }
  }
  return vidAllocPage();
}

void vidFreeScreenPage( PAGE page )
{
  if( vidModeType == vidModeLinear &&
      page >= vidVideoMemory &&
      page <= vidVideoMemory+vidPageSize*vidMaxPage ) {
    PageAllocated[ (page-vidVideoMemory)/vidPageSize] = false;
  }
  else {
    vidFreePage(page);
  }
}

void vidDoInitVideo() {

#ifdef SVGA
  dc = SV_init( false );
  if( !dc ) {
    error( "Cannot initialize graphics" );
  }
#endif

  union REGS regs;
  regs.w.ax = 3;
  int386( 0x10, &regs, &regs );
/*
  regs.h.bl=0; regs.w.ax = 0x1112;
  int386( 0x10, &regs, &regs );
*/

#ifdef __DJGPP__
  conventional_base = __djgpp_conventional_base;
#endif
}

void vidSetVideoMode( int num ) {

  if( num == 0x13 ) {
    vidModeType = vidMode13;
    union REGS regs;
    regs.w.ax = 0x13;
    int386( 0x10, &regs, &regs );
    vidSizeX = 320;
    vidSizeY = 200;
    vidBytesPerLine = 320;
    vidMaxPage = 1;
    vidPageSize = 64000;
    vidVideoMemory = (PAGE)(0xA0000+conventional_base);
  }

  if( num > 0 && num < XMaxMode ) {
    vidModeType = vidModeX;
    XCurrentMode = &XModes[num];
    vidBytesPerLine = vidSizeX = XCurrentMode->x;
    vidSizeY = XCurrentMode->y;
    vidMaxPage = 1;
    vidPageSize = vidSizeY*vidBytesPerLine;
    vidVideoMemory = (PAGE)(0xA0000+conventional_base);
    vidModeType = vidModeX;

    union REGS regs;
    regs.w.ax = 0x13;
    int386( 0x10, &regs, &regs );
    outpw( SC_INDEX, CHAIN4_OFF );
    outpw( SC_INDEX, ASYNC_RESET );
    outp( MISC_OUTPUT, XCurrentMode->clock );
    outpw( SC_INDEX, SEQU_RESTART );
    outp( CRTC_INDEX, 0x11 );
    outp( CRTC_INDEX+1, inp( CRTC_INDEX+1 ) & 0x7F );
    int i;
    for( i=0; i<sizeof(W320)/sizeof(uint); i++ ) {
      outpw( CRTC_INDEX, XCurrentMode->W[i] );
    }
    for( i=0; i<sizeof(H200)/sizeof(uint); i++ ) {
      outpw( CRTC_INDEX, XCurrentMode->H[i] );
    }
    outpw( CRTC_INDEX, ((vidBytesPerLine/8)<<8) + 0x13 );
    outpw( SC_INDEX, 0xF02 );
    memset( vidVideoMemory, 0, 64000 );
  }

  if( num >= 0x100 ) {
    if( num & vbeLinearBuffer && dc->VBEVersion < 0x200 ) {
      error( "VESA VBE 2.0+ with linear frame buffer support required" );
    }
//    if( !SV_setMode( num, false, false, 1 ) ) {
    if( !VBE_setVideoMode( num ) ) {
      char str[256];
      sprintf( str, "Cannot set video mode #%x", num );
      error( str );
    }
    VBE_modeInfo mi;
    if( !VBE_getModeInfo( num & ~vbeLinearBuffer, &mi ) ) {
      error( "Cannot get mode information" );
    }
    if( num & vbeLinearBuffer ) {
      vidModeType = vidModeLinear;
      vidVideoMemory = (PAGE)VBE_getLinearPointer(&mi);
      vidMaxPage = mi.NumberOfImagePages;
      VBE_setDisplayStart( 0, 0, true );
    } else {
      vidModeType = vidModeBanked;
      bank_size = mi.WinSize*1024;
      bank_granularity = mi.WinGranularity*1024;
      vidPageStep = VBE_getPageSize(&mi);
      vidVideoMemory = (PAGE)((mi.WinASegment<<4)+conventional_base);
      vidMaxPage = 1;
    }
    vidSizeX = mi.XResolution;
    vidSizeY = mi.YResolution;
    vidBytesPerLine = mi.BytesPerScanLine;
    vidPageSize = vidBytesPerLine*vidSizeY;
  }

  current_page = vidAllocScreenPage();
  if( vidMaxPage > 1 && vidModeType == vidModeLinear ) {
    flip_page2 = current_page;
    flip_page1 = vidAllocScreenPage();
  }
  if( vidMaxPage > 3 ) vidMaxPage = 3;
}

void vidDoCloseVideo() {
#ifdef __DJGPP__
  __djgpp_nearptr_disable();
#endif
  SV_restoreMode();
  union REGS regs;
  regs.w.ax = 3;
  int386( 0x10, &regs, &regs );
}

int vidChooseVideoMode() {
  int modes[256]={0};
  int maxmode=0;
  union REGS regs;
  regs.w.ax = 3;
  int386( 0x10, &regs, &regs );
  puts( "Choose video mode (ESC exits):\n" );
  puts( "Approximate hardware requirements:" );
  puts( "320x200: 486-66, 3M free RAM	360x240: 486-100, 4M free RAM" );
  puts( "512x384: P5-100, 5M free RAM	640x480: P5-133,  7M free RAM\n" );
  puts( "0) 320x200x256 plain VGA\n" );
  modes['0']=0x13;
  int c='1'; int flag=0;
  puts( "X-modes (VGA compatible) :" );
  int i;
  for(i=1; i<XMaxMode; i++, c++) {
    printf( "%c) %dx%dx256 X-Mode   ", c, XModes[i].x, XModes[i].y );
    if( flag++%2 ) {
      putchar( '\n' );
    }
    modes[c]=i;
  }

#ifdef SVGA
  puts( "\nSVGA modes :" );
  flag=0;
  VBE_modeInfo mi;
  for( ushort* mode=dc->modeList; *mode != 0xFFFF; mode++ ) {
    if (!VBE_getModeInfo(*mode,&mi)) continue;
    if (mi.BitsPerPixel == 8 &&
	mi.XResolution &&
	mi.XResolution <= VID_MAX_SIZE_X &&
	mi.YResolution <= VID_MAX_SIZE_Y ) {
      modes[c]=*mode;
      char* type;
      if( mi.ModeAttributes & vbeMdLinear ) {
	modes[c] |= vbeLinearBuffer;
	type = "LFB  ";
      }
      else {
	type = "banked";
      }
      printf( "%c) %dx%d %s   ", c, mi.XResolution, mi.YResolution, type );
      if( ++flag % 3 == 0 ) {
	putchar( '\n' );
      }
      if( c++ == '9' ) c = 'A';
    }
  }
#endif

  vidHiResMode=modes[c-1];
  if( ++flag % 3 != 1 ) {
    putchar( '\n' );
  }
  printf( "\nType corresponding number : " );
  fflush( stdout );
  do {
    while( !kbhit() );
    c = toupper(getch());
    while( kbhit() ) getch();
  } while( !modes[c] && c != 27 );
  if( c == 27 ) error("User abort");
  return modes[c];
}

void vidWaitRetrace()
{
//  while( !(inp(0x3dA) & 8) );
}

void vidDoSetPalette( vidRGB* pal, int border )
{
  vidWaitRetrace();
  outp(0x3c8,0);
  for( int i=0; i<256; i++ ) {
    outp(0x3c9,pal[i].r>>2);
    outp(0x3c9,pal[i].g>>2);
    outp(0x3c9,pal[i].b>>2);
  }
  union REGS regs;
  regs.h.bh = border; regs.w.ax = 0x1001;
  int386( 0x10, &regs, &regs );
}

inline void copyx( uchar* from, uchar* to, int bytes )
{
  uint* p =(uint*)from;
  for( int i=0; i<bytes; i++ ) to[i] = p[i];
}

void vidCopyX( PAGE screen, PAGE from, int bytes )
{
  outpw( 0x3C4, 0x102 );
  copyx( from, screen, bytes/4 );
  outpw( 0x3C4, 0x202 );
  copyx( from+1, screen, bytes/4 );
  outpw( 0x3C4, 0x402 );
  copyx( from+2, screen, bytes/4 );
  outpw( 0x3C4, 0x802 );
  copyx( from+3, screen, bytes/4 );
}

void vidCopyPageX( PAGE screen, PAGE frompage )
{
  const lines = 16;
  int bytes = vidBytesPerLine*16;
  for( int i=0, n=0; i<vidSizeY/lines; i++, n += bytes ) {
    vidCopyX( screen+n/4, frompage+n, bytes );
  }
}

void vidShowPage( uchar* page )
{
  static frame_time=0;
  if( sysDebug ) {
    static int fps = 0;
    if( (vidFrameCount%3)==0 && sysTimer() > frame_time ) {
      fps = 1*sysTimerRes/(sysTimer()-frame_time);
    }
    for( int i=0; i<fps; i++ ) {
      int c= i<8 ? 255 : 254;
      page[i*3]=255; page[i*3+1]=255;
      page[i*3+vidBytesPerLine]=255; page[i*3+1+vidBytesPerLine]=255;
    }
    frame_time=sysTimer();
  }

  switch( vidModeType ) {
    case vidModeLinear: {
      if( vidMaxPage > 1 &&
	  page >= vidVideoMemory &&
	  page < vidVideoMemory+vidPageSize*vidMaxPage ) {
	VBE_setDisplayStart( 0, (page-vidVideoMemory)/vidBytesPerLine, true );
      }
      else {
	vidCopyPage( vidVideoMemory, page );
      }
      break;
    }
    case vidModeBanked: {
      XCurrentPage = (++XCurrentPage)%vidMaxPage;
      int offset = 0;
      int cur_bank = (XCurrentPage*vidPageStep)/bank_granularity;
      for( int i=0; i<vidPageSize; i+= bank_size ) {
	VBE_setBank( 0, cur_bank );
	cur_bank += bank_size/bank_granularity;
	if( i+bank_size > vidPageSize ) {
	  memcpy( vidVideoMemory, page+i, vidPageSize-i );
	}
	else {
	  memcpy( vidVideoMemory, page+i, bank_size );
	}
      }
      if( vidMaxPage > 1 ) {
	if( !VBE_setDisplayStart( XCurrentPage*vidPageStep%vidBytesPerLine,
			     XCurrentPage*vidPageStep/vidBytesPerLine,
			     true ) ) {
	  error( "Cannot set display start" );
	}
      }
      break;
    }
    case vidMode13: {
      vidWaitRetrace();
      vidCopyPage( vidVideoMemory, page );
      break;
    }
    case vidModeX: {
      if( XCurrentMode->pagenum > 1 ) {
	vidCopyPageX( vidVideoMemory+XCurrentPage*vidSizeX*vidSizeY/4, page );
	vidWaitRetrace();
	outpw( CRTC_INDEX, (((XCurrentPage*vidSizeX*vidSizeY/4)>>8)<<8)+0xC );
	outpw( CRTC_INDEX, (((XCurrentPage*vidSizeX*vidSizeY/4))<<8)+0xD );
	XCurrentPage = (++XCurrentPage)%XCurrentMode->pagenum;
      }
      else {
	vidWaitRetrace();
	vidCopyPageX( vidVideoMemory, page );
      }
      break;
    }
  }
}

static int total;

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage(current_page);
  if( vidMaxPage > 1 && vidModeType == vidModeLinear ) {
    current_page = PAGE( (int)flip_page1 + (int)flip_page2 -
			 (int)current_page );
  }
}

void vidMessage( char* msg )
{
  puts(msg);
}
