/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#pragma pack(0);

#define INCL_VIO
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

#include "video.h"
#include "sys.h"

HFILE ScreenHandle = 0;
PAGE screen_buf = 0;
PAGE current_page = 0;
VIOMODEINFO orig_mode;

void vidDoInitVideo(void)
{
  ULONG action;
  if( DosOpen("SCREEN$", &ScreenHandle, &action, 0, 0,
                 OPEN_ACTION_OPEN_IF_EXISTS, OPEN_FLAGS_NOINHERIT |
                 OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE, NULL) != 0) {
    error( "cannot open screen" );
  }
  orig_mode.cb  = sizeof(orig_mode);
  VioGetMode(&orig_mode, 0);
}

void vidDoCloseVideo()
{
  VioSetMode(&orig_mode, 0);
  if (ScreenHandle != 0)
    DosClose(ScreenHandle);
}

void set_bank( int bank )
{
  struct
    {
      ULONG  length;
      USHORT bank;
      USHORT modetype;
      USHORT bankmode;
    } parameter;
  ULONG datalen, parmlen;

  datalen = 0;
  parmlen = sizeof(parameter);
  parameter.length   = sizeof(parameter);
  parameter.bank     = bank;
  parameter.modetype = 2;
  parameter.bankmode = 0;
  if (DosDevIOCtl(ScreenHandle, 0x80, 1,
                  &parameter, parmlen, &parmlen, NULL, 0, &datalen))
    DosBeep(440, 500);
  datalen = 0;
  parmlen = sizeof(parameter);
  parameter.length   = sizeof(parameter);
  parameter.bank     = bank;
  parameter.modetype = 2;
  parameter.bankmode = 1;
  if (DosDevIOCtl(ScreenHandle, 0x80, 1,
                  &parameter, parmlen, &parmlen, NULL, 0, &datalen))
    DosBeep(880, 500);
}

void vidShowPage( PAGE page )
{
  const bank_size = 65536; // ;-(
  int bank = 0;
  UCHAR lock;
  if( VioScrLock( 0, &lock, 0 ) || lock ) return;
  for( int i=0; i<vidPageSize; i += bank_size ) {
    set_bank(bank++);
    if( i+bank_size > vidPageSize ) {
      memcpy( screen_buf, page+i, vidPageSize-i );
    }
    else {
      memcpy( screen_buf, page+i, bank_size );
    }
  }
  VioScrUnLock(0);
}

void vidSetVideoMode( int foo )
{
  VIOMODEINFO ModeInfo;
  ModeInfo.cb     = 12;
  ModeInfo.fbType = 0xB;
  ModeInfo.color  = 8;
  ModeInfo.col    = 640  / 8;
  ModeInfo.row    = 480 / 16;
  ModeInfo.hres   = 640;
  ModeInfo.vres   = 480;
  if( VioSetMode(&ModeInfo, 0) ) {
    error( "cannot set 640x480 video mode\n"
           "(this demo must be run in full screen os/2 session)" );
  }

  ModeInfo.cb  = sizeof(ModeInfo);
  VioGetMode(&ModeInfo, 0);
  VIOPHYSBUF  PhysBuf;
  PhysBuf.pBuf = (PBYTE) ModeInfo.buf_addr;
  PhysBuf.cb   = 0x10000;
  if (VioGetPhysBuf(&PhysBuf, 0) != 0) {
    error( "cannot get phys buf" );
  }
  screen_buf = (PAGE)MAKEP(PhysBuf.asel[0], 0);

  vidBytesPerLine = vidSizeX = 640;
  vidSizeY = 480;
  vidPageSize = vidBytesPerLine*vidSizeY;
  if( current_page ) cfree(current_page);
  current_page = vidAllocPage();
  vidClearPage( current_page );
  vidShowPage( current_page );
}

extern "C" void* APIENTRY DosFlatToSel( void* );

void vidDoSetPalette( vidPalette pal, int border )
{
  uchar colors[768];
  VIOCOLORREG palb = {
    12,
    3,
    0,
    256,
    (char*)DosFlatToSel(colors)
  };
  for( int i=0; i<256; i++ ) {
    colors[i*3] = pal[i].r/4;
    colors[i*3+1] = pal[i].g/4;
    colors[i*3+2] = pal[i].b/4;
  }
  VIOOVERSCAN bordb = { 6, 1, border };
  if( VioSetState( &palb, 0 ) || VioSetState( &bordb, 0 ) ) {
    error( "cannot set palette" );
  }
}

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage(current_page);
}

void vidMessage( char* msg )
{
  puts(msg);
}

int vidChooseVideoMode()
{
  return 0;
}

KB sysGetKey()
{
  if( kbhit() ) {
    switch( getch() ) {
      case '+': return KB_PLUS;
      case '-': return KB_MINUS;
      case 133: return KB_F11;
      case 27:  return KB_ESC;
    }
  }
  return KB_NONE;
}
