/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "SDL.h"

#include "video.h"
#include "misc.h"
#include "music.h"

static SDL_Surface *screen;
static Uint32 colors[256];

void vidDoInitVideo()
{
  return;
}

void vidDoCloseVideo()
{
  return;
}

void vidSetVideoMode( int mode )
{
  int video_w, video_h;
  Uint32 video_flags;

  video_flags = (SDL_SWSURFACE|SDL_HWPALETTE|SDL_FULLSCREEN|SDL_ANYFORMAT);
  video_w = min( VID_MAX_SIZE_X, mode );
  video_h = video_w*3/4;
  screen = SDL_SetVideoMode(video_w, video_h, 8, video_flags);
  if ( screen == NULL ) {
    error( "Cannot set video mode" );
  }
  if ( (screen->w % 4) != 0 ) {
    error( "Screen width not a multiple of 4" );
  }
  vidBytesPerLine = vidSizeX = screen->w;
  vidSizeY = screen->h;
  vidPageSize = vidBytesPerLine*vidSizeY;
  SDL_WM_SetCaption(PROJECT_NAME, PROJECT_NAME);
}

int vidChooseVideoMode()
{
  return VID_MAX_SIZE_X;
}

void vidDoSetPalette( vidPalette pal, int border )
{
  int i;

  if ( screen->format->palette ) {
    SDL_Color palcolors[256];

    for ( i=0; i<256; i++ ) {
      palcolors[i].r = pal[i].r;
      palcolors[i].g = pal[i].g;
      palcolors[i].b = pal[i].b;
    }
    SDL_SetColors(screen, palcolors, 0, 256);
 } else {
    Uint8 Rloss, Gloss, Bloss;
    Uint8 Rshift, Gshift, Bshift;

    Rloss = screen->format->Rloss;
    Rshift = screen->format->Rshift;
    Gloss = screen->format->Gloss;
    Gshift = screen->format->Gshift;
    Bloss = screen->format->Bloss;
    Bshift = screen->format->Bshift;
    for ( i=0; i<256; i++ ) {
      colors[i] = (pal[i].r>>Rloss)<<Rshift |
                  (pal[i].g>>Gloss)<<Gshift |
                  (pal[i].b>>Bloss)<<Bshift ;
    }
  }
}

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  if ( SDL_LockSurface(screen) < 0 ) {
    return;
  }
  switch (screen->format->BytesPerPixel) {
    case 1:
    {
      Uint8 *pixels;
      Uint16 w, h, skip;

      pixels = (Uint8 *)screen->pixels;
      skip = screen->pitch-screen->w;
      for ( h = screen->h; h; --h ) {
        for ( w = screen->w/4; w; --w ) {
          *pixels++ = dither_table[ (*bw++<<8) + *color++ ];
          *pixels++ = dither_table[ (*bw++<<8) + *color++ ];
          *pixels++ = dither_table[ (*bw++<<8) + *color++ ];
          *pixels++ = dither_table[ (*bw++<<8) + *color++ ];
        }
        pixels += skip;
      }
    }
    break;

    case 2:
    {
      Uint16 *pixels;
      Uint16 w, h, skip;

      pixels = (Uint16 *)screen->pixels;
      skip = screen->pitch/2-screen->w;
      for ( h = screen->h; h; --h ) {
        for ( w = screen->w/4; w; --w ) {
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
        }
        pixels += skip;
      }
    }
    break;

    case 3:
    {
      Uint8 *pixels;
      Uint16 w, h, skip;

      pixels = (Uint8 *)screen->pixels;
      skip = screen->pitch-screen->w*3;
      for ( h = screen->h; h; --h ) {
        for ( w = screen->w/4; w; --w ) {
          memcpy(pixels, &colors[dither_table[ (*bw++<<8) + *color++ ]], 3);
          pixels += 3;
          memcpy(pixels, &colors[dither_table[ (*bw++<<8) + *color++ ]], 3);
          pixels += 3;
          memcpy(pixels, &colors[dither_table[ (*bw++<<8) + *color++ ]], 3);
          pixels += 3;
          memcpy(pixels, &colors[dither_table[ (*bw++<<8) + *color++ ]], 3);
          pixels += 3;
        }
        pixels += skip;
      }
    }
    break;

    case 4:
    {
      Uint32 *pixels;
      Uint16 w, h, skip;

      pixels = (Uint32 *)screen->pixels;
      skip = screen->pitch/4-screen->w;
      for ( h = screen->h; h; --h ) {
        for ( w = screen->w/4; w; --w ) {
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
          *pixels++ = colors[dither_table[ (*bw++<<8) + *color++ ]];
        }
        pixels += skip;
      }
    }
    break;
  }
  SDL_UnlockSurface(screen);
  SDL_UpdateRect(screen, 0, 0, 0, 0);
}

void vidMessage( char* str )
{
  puts(str);
}

KB sysGetKey()
{
  SDL_Event event;

  while ( SDL_PollEvent(&event) ) {
    switch (event.type) {
      case SDL_QUIT:
      {
        return KB_ESC;
      }
      case SDL_KEYDOWN:
      {
        switch (event.key.keysym.sym) {
          case SDLK_MINUS:
          case SDLK_KP_MINUS:
          {
            return KB_MINUS;
          }
          case SDLK_EQUALS:
          case SDLK_KP_PLUS:
          {
            return KB_PLUS;
          }
          case SDLK_F11:
          {
            return KB_F11;
          }
          case SDLK_ESCAPE:
          {
            return KB_ESC;
          }
          case SDLK_RIGHTBRACKET:
          {
            return KB_NEXT;
          }
        }
      }
    }
  }
  return KB_NONE;
}

