/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "parts.h"
#include "music.h"
#include "common.h"

const WAVE_WIDTH = VID_MAX_SIZE_X/3;

struct Wave: public Part {
  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what );

  uchar* wave;
  int width;
  int pat_len;
  bool direction;
  Image* fence;
};

void Wave::Init()
{
  Part::Init();
  width = vidScaleX(WAVE_WIDTH);
  wave = new uchar[width];
  for( i=0; i<width; i++ ) {
    wave[i] = (VID_AVG_BRIGHT)*sin(i*M_PI/width);
  }
  part_pal = dither1->palette;
  ::dither = dither1;
  fence = new Image( "fence.raw", STRETCH_SCREEN );
}

void Wave::Start( int what )
{
  Part::Start(what);
  direction = what & 1;
  if( what & 0x80 ) {
    ::dither = dither4;
    part_pal = dither4->palette;
  }
}

void Wave::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame( color, bw, 0 );
  if( what & 0x100 ) {
    vidCopyPage( color, fence->data );
    pat_len = (musGetRowTime()*64);
  }
  else {
    pat_len = (musGetRowTime()*48);
  }
  int start_x;
  if( !direction ) {
    start_x = 1.15*cur_timer*(vidSizeX+width)/pat_len - width;
  }
  else {
    start_x = vidSizeX - 1.1*cur_timer*(vidSizeX+width)/pat_len;
  }
  uchar* line = new uchar[vidSizeX];
  memset( line, what & 0xFF, vidSizeX );
  int offset=0, n=width;
  if( start_x < 0 ) {
    offset = -start_x;
    start_x = 0;
    n -= offset;
  }
  if( start_x+n > vidSizeX ) {
    n -= start_x + n - vidSizeX;
  }
  if( n>0 ) {
    memcpy( line+start_x, wave+offset, n );
    for( i=0; i<vidSizeY; i++ ) {
      memcpy( bw, line, vidSizeX );
      bw += vidBytesPerLine;
    }
  }
  delete line;
}

Part* partWave = new Wave;
