#ifndef __BMP_FILE_H__
#define __BMP_FILE_H__

// pack the structure members by 1 byte align
// MS compiler dependand
#  if defined(__GNUC__) || defined(__SUNPRO_C) || defined(__SUNPRO_CC)
#    pragma pack(1)
#define ANONSTRUCT_NOT_SUPPORTED
#  else 
#    pragma pack(push ,idheader)
#    pragma pack(1)
#  endif


// the BMP file structures and types

// color info
typedef struct tagRGBQUAD
{
	union 
	{
		long longData;
		struct 
		{
			Uint8 Blue;
			Uint8 Green;
			Uint8 Red;
			Uint8 Alpha;
		}
#ifdef ANONSTRUCT_NOT_SUPPORTED
st1
#endif
		;
	};
} RGBQUAD;

// file header
typedef struct tagBITMAPFILEHEADER { 
  Uint16    bfType; 
  Uint32   bfSize; 
  Uint16    bfReserved1; 
  Uint16    bfReserved2; 
  Uint32   bfOffBits; 
} BITMAPFILEHEADER, *PBITMAPFILEHEADER; 

// image info header
typedef struct tagBITMAPINFOHEADER{
  Uint32  biSize; 
  Sint32  biWidth; 
  Sint32  biHeight; 
  Uint16  biPlanes; 
  Uint16  biBitCount ;
  Uint32  biCompression; 
  Uint32  biSizeImage; 
  Sint32  biXPelsPerMeter; 
  Sint32  biYPelsPerMeter; 
  Uint32  biClrUsed; 
  Uint32  biClrImportant; 
} BITMAPINFOHEADER, *PBITMAPINFOHEADER; 

// the bitmap header 
typedef struct tagBITMAPINFO { 
  BITMAPINFOHEADER bmiHeader; 
  RGBQUAD          bmiColors[1]; 
} BITMAPINFO, *PBITMAPINFO; 

// restore the default alignment
#  if defined(__GNUC__) || defined(__SUNPRO_C) || defined(__SUNPRO_CC)
#    pragma pack()
#  else
#    pragma pack(pop, idheader)
#  endif

/*
Loads BMPfile from a file. the file can be separated vertically to
m_count subimages;
*/
class CBMPFile {
public:
	// sublimages count
	int m_count;
	// the bitmap bits(including the header
	unsigned char* m_pBits;

	// contructor
	CBMPFile(int count = 1);
	// destructor
	~CBMPFile();
	// read it from file
	bool load(char* pFileName);
	//reutrn pointer to image header
	PBITMAPINFOHEADER getHeader();
	// the bits accessor
	Uint8* getBits();
	// the width of the image
	int getWidth();
	// the height of the image
	int getHeight();
};

// manipulate a part of the Image.
class CImage
{
public:
	// pointer to actual image
	CBMPFile* m_pBitmap;
	// constructor
	CImage(CBMPFile* pBitmap);
	// calculate and return the addres of the subimage by the index
	Uint8* getBits(int index);
	// calculated width of the sublimage
	int getWidth();
	// calculated height of the subimage
	int getHeight();
	// hmm... paint the sublimage 'index' to memory buffer pointed by pBase with 
	// dimmesions resp. mapWidth and mapHeight, at position x,y
	// the memory image should represent the image buffer with 24bit color dept
	void paint(unsigned char* pBase, int mapWidth, int mapHeight, int x, int y, int index);
};

#endif