#include <SDL.h>
#include "sdlapp.h"
#include "scrnctl.h"
#include "bmpfile.h"
#include "buttons.h"

// is the mouse is over the control area
int BMPButton::hittest(int x, int y)
{
	if ((xPos <= x) && (x < (xPos+wCtl)) && 
		(yPos <= y) && (y < (yPos+hCtl)))
		return true;
	return false;
}// hittest

// repaint
void BMPButton::repaint()
{
	// we should have an images attached to display something
	if (pImage == NULL)
		return;
	// an subimage image representation of the bitmap file
	CImage image(pImage);
	// just paint the current state image at the control position
	image.paint(CScreenControl::pGlobalDC->m_pBase, 
				CScreenControl::pGlobalDC->mapWidth, 
				CScreenControl::pGlobalDC->mapHeight, 
				xPos, yPos, state);
	// paint also an dkGray border around it
	doRect(xPos-1, yPos-1, wCtl+1, hCtl+2, 128, 128);
} // repaint()

// on left mouse button down event
void BMPButton::onLButtonDown(int x, int y, unsigned char flags)
{
	// change the state to 4(down)
	state = 4;
	// grab tha 'focus'
	getApp()->setFocus(this);
	// hey... theApp! Repaint me!
	getApp()->Invalidate(this);
} // onLButtonDown

// on left mouse button up
void BMPButton::onLButtonUp(int x, int y, unsigned char flags)
{
	// check if we are in pressd state
	if (state == 4)
	{
		// change the state to released
		state = 0;
		// notify the app by invoking the onClick() method
		getApp()->onClick(this);
	}
	// release the focus
	getApp()->setFocus(NULL);
	// repaint the button
	getApp()->Invalidate(this);
} // onLButtonUp

// on mouse move handler
void BMPButton::onMouseMove(int x, int y, unsigned char flags)
{
	// are we have an focus 
	if (getApp()->getFocus() != this) return;
	// yeah! we have it!
	// are tha mouse is inside the control area 
	if (hittest(x,y))
	{
		// yes? are we noyt in pressed state?
		if (state != 4)
		{
			// so change the state to pressed
			state = 4;
			// repaint me
			getApp()->Invalidate(this);
		}
	} else {
		// we are not in the control's client area
		// check if the state was pressed
		if (state == 4)
		{
			// 'release' the button
			state = 0;
			// repaint
			getApp()->Invalidate(this);
		}
	}// hittest handling
} // onMouseMove

//---------------------------------------------------------------------
// the hittest implementation for the counter
int BMPCounterButton::hittest(int x, int y)
{
	// x and y should be in the control area to return true
	if ((xPos <= x) && (x < (xPos+wCtl)) && 
		(yPos <= y) && (y < (yPos+hCtl)))
		return true;
	return false;
} // hittest()

// repaint implementation of the counters
void BMPCounterButton::repaint()
{
	// no image? just return
	if (pImage == NULL)
		return;
	// here are the image indexed for all 3 digit places of the control
	char digits[3] = {11,11,11};
	// is number positive?
	if (number >=0)
	{
		// put the most significant to the right
		digits[0] = ((number%1000) / 100);
		// then the middle digit
		digits[1] = ((number%100) / 10);
		// finaly the last one
		digits[2] = (number%10);
	}
	// get the subimage representation
	CImage image(pImage);
	// paint all three digits 
	image.paint(CScreenControl::pGlobalDC->m_pBase, 
				CScreenControl::pGlobalDC->mapWidth, 
				CScreenControl::pGlobalDC->mapHeight, 
				xPos, yPos, digits[0]);
	image.paint(CScreenControl::pGlobalDC->m_pBase, 
				CScreenControl::pGlobalDC->mapWidth, 
				CScreenControl::pGlobalDC->mapHeight, 
				xPos+image.getWidth(), yPos, digits[1]);
	image.paint(CScreenControl::pGlobalDC->m_pBase, 
				CScreenControl::pGlobalDC->mapWidth, 
				CScreenControl::pGlobalDC->mapHeight, 
				xPos+2*image.getWidth(), yPos, digits[2]);
	// and bump the rect around them
	bumpRect(xPos, yPos, wCtl, hCtl, 1);
} // repaint