#include <string.h>
#include <SDL.h>
#include "scrnctl.h"
#include "bmpfile.h"
#include "sdlapp.h"
#include "buttons.h"
#include "theGrid.h"
#include "mainapp.h"

//constructor
MySDLApp::MySDLApp()
{
	// all members to defualt values
	pRunningPath = NULL;
	m_TimerID = NULL;
	left = NULL; 
	right = NULL;
	smile = NULL;
	pdc = NULL;
	desktop = NULL;
	pGrid = NULL;
	//also there will be 16 subimages in th emionefield image
	fileNums.m_count = 16;
	// 12 digits (0-9,minus, empty)
	fileDigits.m_count = 12;
	// 5 face states
	fileSmiley.m_count = 5;
}// constructor

//destructor
MySDLApp::~MySDLApp()
{
	// delete all control instances
	delete left; 
	delete right ; 
	delete smile; 
	delete desktop; 
	delete pdc;
	delete pGrid;
} // destructor

// onTimer handler
Uint32 MySDLApp::onTimer(Uint32 interval, void *param)
{
	// increment the right control
	right->number++;
	// repaint it
	while(scrlock() < 0);
	right->repaint();
	scrunlock(right);
	// chck th etime elapsed
	if (right->number >= 999)
	{
		// if we are over 10000 stothe timer
		SDL_RemoveTimer(m_TimerID);
		m_TimerID = NULL;
	}
	// continue to receive the timer events on the same time interval (1s)
	return interval;
}// onTimer()

// onUserevents
Uint32 MySDLApp::onUserEvent(SDL_UserEvent* pEvent)
{
	// chck the user event code
	switch (pEvent->code)
	{
	case evtFaceBack:
		// change the face back to 'smile' ->lbtn down
		smile->state=0;
		Invalidate(smile);
		break;
	case evtFaceO:
		// change the face to 'o' image -> lbtn up
		smile->state=1;
		Invalidate(smile);
		break;
	case evtMarkChange:
		// added a mark
		// decrease the mine count
		left->number--;
		//invalidate
		Invalidate(left);
		break;
	case evtMarkChangePlus:
		// mark removed
		// increment the mine counter
		left->number++;
		Invalidate(left);
		break;
	case evtStartTimer:
		// start the timer when the newgame begins
		m_TimerID = SDL_AddTimer(1000, SDLApp::AppTimerCallback, NULL);
		break;
	case evtStopTimer:
		// stop the timer -> game over
		SDL_RemoveTimer(m_TimerID);
		m_TimerID = NULL;
		break;
	case evtStartGame:
		// start the game first remove the timer if any
		SDL_RemoveTimer(m_TimerID);
		m_TimerID = NULL;
		// clear the time counter
		right->number = 0;
		// clear the minefield
		pGrid->clear();
		// need to begin new game
		pGrid->bNewGame = true;
		// set the initial game state
		pGrid->eState = Grid::sWait;
		// update the number of mines in the mine counter
		left->number = 99;
		// repaint all the controls
		Invalidate(pGrid);
		Invalidate(left);
		Invalidate(right);
		break;
	} // end switch(user event code)
	return 0;
} // onUserEvent


// initInstance
bool MySDLApp::initInstance()
{
	// preocess SDLApp initinstance if all is ok continue
	if (!SDLApp::initInstance()) return false;
	char buf[1024];
	strcpy(buf, pRunningPath);
	strcat(buf, "410.bmp");
	// load images
	if (!fileNums.load(buf)) return false;
	strcpy(buf, pRunningPath);
	strcat(buf, "420.bmp");
	if (!fileDigits.load(buf)) return false;
	strcpy(buf, pRunningPath);
	strcat(buf, "430.bmp");
	if (!fileSmiley.load(buf)) return false;
	// need to calculate various control sizes
	CImage i(&fileDigits);
	//update left/minecounter control
	left = new BMPCounterButton(20,20, 3*fileDigits.getWidth(), i.getHeight());
	left->pImage = &fileDigits;
	
	//update right/timecounter control
	right = new BMPCounterButton(thescreen->w-20-3*fileDigits.getWidth(),20, 3*fileDigits.getWidth(), i.getHeight());
	right->pImage = &fileDigits;
	
	// update the smile face button
	i.m_pBitmap = &fileSmiley;
	smile = new BMPButton((thescreen->w - fileSmiley.getWidth()) /2,20, i.getWidth(), i.getHeight());
	smile->pImage = &fileSmiley; 

	// initialize the DC for the controls
	pdc = new PDC(thescreen);
	CScreenControl::pGlobalDC = pdc;
	// create the desktop control
	desktop = new Desktop;

	// the minefiled control at the end
	i.m_pBitmap = &fileNums;
	// the grid dimensions
	pGrid = new Grid(30, 16);
	pGrid->pImages = &fileNums;
	// clac the size and position
	pGrid->xPos = (thescreen->w - i.getWidth()*30)/2; 
	pGrid->yPos = ((thescreen->h - i.getHeight()*16)/2)+20; 
	pGrid->wCtl = i.getWidth()*30;
	pGrid->hCtl = i.getHeight()*16;
	// test the generate and recalc subroutines of the grid control
	pGrid->Generate(100);
	pGrid->Recalc();
	// number of mines in the left minecounetr control
	left->number = 99;
	// initial
	while(scrlock() < 0);
	desktop->repaint();
	scrunlock();

	while(scrlock() < 0);
	left->repaint();
	scrunlock(left);
	
	while(scrlock() < 0);
	right->repaint();
	scrunlock(right);

	while(scrlock() < 0);
	smile->repaint();
	scrunlock(smile);

	while(scrlock() < 0);
	pGrid->repaint();
	scrunlock(pGrid);

	return true;
} // init instance

// route events
void MySDLApp::routeEvent(SDL_Event* event)
{
	bool route = true;

	// aray of pointers to all screen control that will receive the events
	// in th efuture all controls shoud register themselfs to be processed here
	CScreenControl* ctls[] = {smile, pGrid, NULL};
	CScreenControl** pCtl =ctls; 

	// chack the event
	switch(event->type)
	{
		case SDL_MOUSEBUTTONDOWN:
			{
				SDL_MouseButtonEvent* mouseEvent = (SDL_MouseButtonEvent*)event;
				// mouse button down event . no focus control
				if (getApp()->getFocus() == NULL)
				{
					while (*pCtl)
					{
						// enum controls and for each the the hittest succeded route to it
						if ((*pCtl)->hittest(mouseEvent->x, mouseEvent->y))
						{
							// left or right button event 
							if (mouseEvent->button == 1)
								(*pCtl)->onLButtonDown(mouseEvent->x -(*pCtl)->xPos, mouseEvent->y - (*pCtl)->yPos, mouseEvent->state);
							else
								(*pCtl)->onRButtonDown(mouseEvent->x -(*pCtl)->xPos, mouseEvent->y - (*pCtl)->yPos, mouseEvent->state);
							route = false;
							break;
						}
						pCtl++;
					}// end while
				} else {
					// we have the control with the focus
					// again the distinkt left/right hadlers are invoked
					if (mouseEvent->button == 1)
						getApp()->getFocus()->onLButtonDown(mouseEvent->x , 
							mouseEvent->y, mouseEvent->state);
					else
						getApp()->getFocus()->onRButtonDown(mouseEvent->x,
							mouseEvent->y, mouseEvent->state);
					route = false;
				} // focus control processing
			} // mouse button down
			break;
		case SDL_MOUSEBUTTONUP:
			{
				// the same processing as for down events
				SDL_MouseButtonEvent* mouseEvent = (SDL_MouseButtonEvent*)event;
				if (getApp()->getFocus() == NULL)
				{
					while (*pCtl)
					{
						if ((*pCtl)->hittest(mouseEvent->x, mouseEvent->y))
						{
							if (mouseEvent->button == 1)
								(*pCtl)->onLButtonUp(mouseEvent->x -(*pCtl)->xPos, 
									mouseEvent->y - (*pCtl)->yPos, mouseEvent->state);
							else
								(*pCtl)->onRButtonUp(mouseEvent->x -(*pCtl)->xPos, 
									mouseEvent->y - (*pCtl)->yPos, mouseEvent->state);
							route = false;
							break;
						}
						pCtl++;
					}// end while
				} else {
					if (mouseEvent->button == 1)
						getApp()->getFocus()->onLButtonUp(mouseEvent->x, 
							mouseEvent->y , mouseEvent->state);
					else
						getApp()->getFocus()->onRButtonUp(mouseEvent->x , 
							mouseEvent->y , mouseEvent->state);
					route = false;
				} // route to focus ctl
			} // button up
			break;
		case SDL_MOUSEMOTION:
			{
				// the same processing as for up/down events 
				SDL_MouseMotionEvent* mouseEvent = (SDL_MouseMotionEvent*)event;
				if (getApp()->getFocus() == NULL)
				{
					while (*pCtl)
					{
						if ((*pCtl)->hittest(mouseEvent->x, mouseEvent->y))
						{
							(*pCtl)->onMouseMove(mouseEvent->x -(*pCtl)->xPos, mouseEvent->y - (*pCtl)->yPos, mouseEvent->state);
							route = false;
							break;
						}
						pCtl++;
					}// end while
				} else {
					getApp()->getFocus()->onMouseMove(mouseEvent->x, mouseEvent->y, mouseEvent->state);
					route = false;
				}
			} // mouse motion
		break;
		// if it is a Key
		case SDL_KEYDOWN:
			int key=event->key.keysym.sym;
			// check for escape
			if(key==SDLK_F2) 
			{
				postUserEvent(evtFaceBack);
				postUserEvent(evtStartGame);
				route = false;
			}
	} // switch
	
	// other evens throught base class routine(QUIT and USER events will be routed there)
	if (route)
		SDLApp::routeEvent(event);
} // routeEvent

// on click handler
void MySDLApp::onClick(CScreenControl* pCtl)
{
	// if the sender is smile button
	if (pCtl == smile)
	{
		// just start the game
		postUserEvent(evtStartGame);
	}
	// if the sender is the Grid control
	if (pCtl == pGrid)
	{
		// check for game over state
		if (pGrid->eState == Grid::sGameOver)
		{
			// update the button
			smile->state = (pGrid->bEnd)?3:2;
			Invalidate(smile);
		}
	}
} // onclick

