
#include <string.h>
#include <SDL.h>
#include "bmpfile.h"
#include "scrnctl.h"

// the static member of the ScreenControl device context :-)
PDC* CScreenControl::pGlobalDC = NULL;

// the class Desktop repaint method
// it just fill all the space with ltGray pixels
void Desktop::repaint()
{
	// using the memset to write there
	memset(CScreenControl::pGlobalDC->m_pBase, 192, CScreenControl::pGlobalDC->mapHeight*
		CScreenControl::pGlobalDC->mapWidth*3);
}

// paint a rect with ulocor left and top sides and lcolor resp. 
// down and right sides
void doRect(int x, int y, int w, int h, unsigned char ucolor, unsigned char lcolor)
{
	// retrive the pointer to image pane 
	unsigned char * pBegin = CScreenControl::pGlobalDC->m_pBase;
	// calculate the left side memory location
	pBegin = pBegin+(y*CScreenControl::pGlobalDC->mapWidth + x)*3;
	// the length in pixels of each line
	int len = (w);
	int rightV = true;
	// is whole line is 'visible', if not crop it
	if ((x+w) >= CScreenControl::pGlobalDC->mapWidth)
	{
		len = (CScreenControl::pGlobalDC->mapWidth - x -1);
		rightV = false;
	}
	// calulate it from pixeels to memory bytes
	len *= 3;
	// calculate the end memory location(cropped)
	unsigned char * pEnd = pBegin+len;

	// draw the upper Horisontal line
	memset(pBegin, ucolor, pEnd - pBegin);
	// advance tha begin and end memory locations
	pBegin+=CScreenControl::pGlobalDC->mapWidth*3;
	pEnd  +=CScreenControl::pGlobalDC->mapWidth*3;
	// for each vertical pixel paint a dot at begin and end locations
	int i;
	for (i = 0; i < h-2; i++)
	{
		if ((y+i) >= CScreenControl::pGlobalDC->mapHeight)
			break;
		memset(pBegin, ucolor, 3); // only one pix
		if (rightV)
			memset(pEnd, lcolor, 3); // only one pix
		pBegin+=CScreenControl::pGlobalDC->mapWidth*3;
		pEnd  +=CScreenControl::pGlobalDC->mapWidth*3;
	} // end V lines
	// can we paint the rest of the rect?
	if ((y+i) >= CScreenControl::pGlobalDC->mapHeight)
		return;
	// paint the lower Horisontal line
	memset(pBegin, lcolor, (pEnd - pBegin +3) ); // only one pix
	memset(pBegin, ucolor, 3);
	// that's all
} // doRect()

// draw the 'bump' enclosing rects on the desired screen position
void bumpRect(int x, int y, int w, int h, int bump)
{
	for (int i = 1; i <= bump; i++)
	{
		// just invoke the doRect routine with ltGray nad dkGray colors
		doRect(x-i, y-i, w+2*i, h+2*i, 128, 255);
	}
}// bumpRect
