#ifndef __SCRNCTL_H__
#define __SCRNCTL_H__


//somethig like a device context - this is actually the 
// information about the pane where wi like to draw
class PDC
{
public:
	// pane image bits starts here
	unsigned char* m_pBase;
	// dimensions
	int mapWidth;
	int mapHeight;
	// construct fom the scratch
	PDC(void* pBase, int w , int h)
	{
		m_pBase = (unsigned char*)pBase;
		mapWidth = w;
		mapHeight = h;
	}
	// construct by SDL_Surface pointer
	PDC(SDL_Surface* pSf)
	{
		m_pBase = (unsigned char*)pSf->pixels;
		mapWidth = pSf->w;
		mapHeight = pSf->h;
	}
};

// here is a base class for all screen elements that can be painted to the screen
// also they receive some notifications by the app
class CScreenControl
{
public:
	// pointer to the curent instance of the dicplay context
	static PDC* pGlobalDC;
	// control dimensions
	int xPos,yPos, wCtl, hCtl;
	// inline constructor
	CScreenControl(int x,int y, int w, int h)
	{
		xPos = x; yPos = y; wCtl = w; hCtl = h;
	}

//  repaint event should be handled for each descendant
virtual void repaint() = 0;

// the hittest reurn true if the x,y coords are whitin the control boundaries
virtual int hittest(int x, int y) = 0;
// various event handlers
// NOTE: when the 'focus' is grabed  all x and y are absolute
// otherwise they are in 'client' space -> exe upperlef pix of the control has 0,0 coords
virtual void onLButtonDown(int x, int y, unsigned char flags){}
virtual void onRButtonDown(int x, int y, unsigned char flags){}
virtual void onLButtonUp(int x, int y, unsigned char flags){}
virtual void onRButtonUp(int x, int y, unsigned char flags){}
virtual void onMouseMove(int x, int y, unsigned char flags){}
};


// the representation of the main window of the system
// it is always hited and is alway on the botom
// just like to paint all the defaults here
class Desktop : public CScreenControl
{
public:
	Desktop():CScreenControl(0, 0, CScreenControl::pGlobalDC->mapWidth, CScreenControl::pGlobalDC->mapHeight)
	{
	}
	virtual void repaint();
	virtual int hittest(int x, int y)
	{
		return true;
	}
};

// paint the 3d etched rect on the desired place
// bump argument defines 'how' mush bump rects we like
void bumpRect(int x, int y, int w, int h, int bump);
// internaly used by the bumpRect to produce the desired effect
void doRect(int x, int y, int w, int h, unsigned char ucolor, unsigned char lcolor);

#endif