/* Fireworks demo written by Dave Ashley */
/* dash@xdr.com */
/* http://www.xdr.com/dash */
/* Sat Jun 13 02:46:09 PDT 1998 */
/* This is my first attempt at an SDL program */
/* See the SDL home page http://www.devolution.com/~slouken/projects/SDL/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <SDL.h>
#include "bmpfile.h"
#include "scrnctl.h"
#include "sdlapp.h"
#include "buttons.h"
#include "theGrid.h"
#include "mainapp.h"


int main(int argc, char *argv[])
{
	// initialise the random generator at startup
	srand(time(NULL));
	char* path = argv[0];
	int len = 0;
	int pos_of_last_slash = 0;
	while (*path)
	{
		if (*path == '\\' || *path == '/')
			pos_of_last_slash = path - argv[0];
		path++;
		len++;
	}
	char* copy_of_path = new char[len];
	strncpy(copy_of_path, argv[0], pos_of_last_slash+1);
	copy_of_path[pos_of_last_slash+1] = 0;
	// the app instance
	MySDLApp app;
	app.pRunningPath = copy_of_path;
	// init the app
	if (!app.initInstance()) return 1;
	// if ok run it
	app.run();
	// process the application cleanup
	app.exitInstance();
	delete copy_of_path;
	// bye
	return 0;
} // main
