#include <stdio.h>
#include <SDL.h>
#include "sdlapp.h"
#include "scrnctl.h"

// the pointer to the SDL application
SDLApp* SDLApp::theApp = NULL;

// dimesions of the screen
int SDLApp::XSIZE = 512;
int SDLApp::YSIZE = 340;

// global accessor o the app instance
SDLApp* getApp()
{
	return SDLApp::theApp;
}

// lock the SDL surface screen fro writing
int SDLApp::scrlock()
{
	// using the SDL primitives
	if(SDL_MUSTLOCK(thescreen))
	{
		// lock it
		if ( SDL_LockSurface(thescreen) < 0 )
		{
			fprintf(stderr, "Couldn't lock display surface: %s\n",
								SDL_GetError());
			return -1;
		}
	}
	return 0;
} // scrlock

// unlock the SDL screen
void SDLApp::scrunlock(CScreenControl* pCtl /*= NULL*/)
{
	// unlock it
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	// if tehre is a poinmter to screen control - update the covered area or whole surface
	if (pCtl == NULL)
		SDL_UpdateRect(thescreen, 0, 0, 0, 0);
	else
		SDL_UpdateRect(thescreen, pCtl->xPos, pCtl->yPos, pCtl->wCtl, pCtl->hCtl);
} // scrunlock

//second version of the unlck routine with predefined area for update
void SDLApp::scrunlock(int x, int y, int w, int h)
{
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	SDL_UpdateRect(thescreen, x, y, w, h);
} // scrunlock


// init instance of the App
bool SDLApp::initInstance()
{
	// SLD init including the video memory and the timers
	if ( SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0 )
	{
		// if we fail
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		return false;
	}
	// set tha videoflags
	long videoflags = SDL_SWSURFACE|SDL_HWPALETTE;

	// retrive the SDL surface
	thescreen = SDL_SetVideoMode(SDLApp::XSIZE, SDLApp::YSIZE, 24, videoflags);
	if ( thescreen == NULL )
	{
		// if we fail
		fprintf(stderr, "Couldn't set display mode: %s\n",
							SDL_GetError());
		// and quit
		SDL_Quit();
		return false;
	}
	// set the main app poinet to that app
	theApp = this;
	// set that there is no control with the focus
	pFocus = NULL;
	return true;
} // init instance

// on exit instance
void SDLApp::exitInstance()
{
	// just deinitialize the SDL engine
	SDL_Quit();
}

// on idle - just nothing
void SDLApp::onIdle() {}

// main app loop
void SDLApp::run()
{
	int done = 0;
	SDL_Event event;
	// until we are ok
	while(!done)
	{
		// performany background processing 
		onIdle();
		// check for SDL event in the queue
		while(SDL_PollEvent(&event))
		{
			switch (event.type)
			{
			case SDL_QUIT:
				done = 1;
				break;
			default:
				// if not quit event -> route it 
				routeEvent(&event);
				break;
			}
		} //while event
	} // !done
} // run

// route events 
void SDLApp::routeEvent(SDL_Event* event)
{
	switch (event->type)
	{
		// if it is a Key
		case SDL_KEYDOWN:
			int key=event->key.keysym.sym;
			// check for escape
			if(key==SDLK_ESCAPE) 
			{
				SDL_QuitEvent ev;
				ev.type = SDL_QUIT;
				// post Quit event
				SDL_PushEvent((SDL_Event*)&ev);
			}
		break;
	} // switch
	// are the event is User
	if (event->type >= SDL_USEREVENT && event->type < SDL_NUMEVENTS)
	{
		// route any user event
		onUserEvent((SDL_UserEvent*)event);
	}
} // route event

// invalidate the control
void SDLApp::Invalidate(CScreenControl* pCtl)
{
	// try to lock the screen
	while(scrlock() < 0);
	// repaint control
	pCtl->repaint();
	// unlock and update the screen
	scrunlock(pCtl);
} // invalidate

// set the focus to the control
CScreenControl* SDLApp::setFocus(CScreenControl* pCtl)
{
	// return the control that has the focus
	CScreenControl* pRet = pFocus;
	pFocus = pCtl;
	return pRet;
}// setFocus

//get the control with the focus if any
CScreenControl* SDLApp::getFocus()
{
	return pFocus;
} // getFocus

// static finction that will receive all timer events and then it 
// will route them to the app instance via the theApp static member of the SDLApp class
Uint32 SDLApp::AppTimerCallback(Uint32 interval, void *param)
{
	// are we have an initialized app yet?
	if (SDLApp::theApp != NULL)
		return SDLApp::theApp->onTimer(interval, param);
	return 0;
}// appTimercallback

// onClick method
void SDLApp::onClick(CScreenControl*)
{
	// empty here
}

// onTimer() on any timer event that occures this is the app handler to process them
Uint32 SDLApp::onTimer(Uint32 interval, void *param)
{ 
	// we just return the same interval to continue to receive the Timer events
	return interval;	
}// onTimer

// onUserEvents  handler
Uint32 SDLApp::onUserEvent(SDL_UserEvent* pEvent)
{ 
	return 0;	
} // onUserEvent

// helper to post User events
void SDLApp::postUserEvent(int code)
{
	// construct and initialise the UserEvent
	SDL_UserEvent ev;
	ev.type = SDL_USEREVENT;
	ev.code = code;
	ev.data1 = NULL;
	ev.data2 = NULL;
	//push it in the Event queue
	SDL_PushEvent((SDL_Event*)&ev);
}// portUserEvent
