#ifndef __SDL_APP_H__
#define __SDL_APP_H__

// reference to the CScreenContol classes (used only as pointers here
class CScreenControl;

// the Stl application 
class SDLApp
{
public:
	// pointer to the only instance of the SDLApp
	static SDLApp* theApp;
	// the dimensions of the app screen
	static int XSIZE, YSIZE;
	// variouse user events indexes
	// start Timer, stop timer ,start game, makred one, change the face button
	// restore the face button removed mark

	enum {evtStartTimer = 1, evtStopTimer, evtStartGame, 
			evtMarkChange, evtFaceO, evtFaceBack, evtMarkChangePlus};

	// the timer calback function. The Timer event is routed to the only instance of the SDLApp
	static Uint32 AppTimerCallback(Uint32 interval, void *param);
	// pointer to rthe SDLsurface
	SDL_Surface *thescreen;
	// pointer to the control with the 'focus' all mouse and keyboard events are routed 
	// to that control first
	CScreenControl* pFocus;
	
	// lock the SDL surface
	int scrlock();
	// unlock he SDLsurface and invalidate the area covered by the Control
	void scrunlock(CScreenControl* pCtl = NULL);
	// the same as above but invalidates desired area
	void scrunlock(int x, int y, int w, int h);
	// init the instance of the app
	virtual bool initInstance();
	// when the app is about to quit
	virtual void exitInstance();
	// perform any background processing whitin this method
	virtual void onIdle();
	// main loop only throught the run method
	virtual void run();
	//route any SDL events here
	virtual void routeEvent(SDL_Event* event);
	// invalidate control area
	virtual void Invalidate(CScreenControl* pCtl);
	// set the focus to desired control
	virtual CScreenControl* setFocus(CScreenControl* pCtl);
	// retrive the control with the focus
	virtual CScreenControl* getFocus();
	// on click notifications will go here
	virtual void onClick(CScreenControl*);
	// all timer events throught application timer callback procedure are routed to 
	// this method of the main application(pointed by theApp pointer)
	virtual Uint32 onTimer(Uint32 interval, void *param);
	// any user events are routed to this method
	virtual Uint32 onUserEvent(SDL_UserEvent* pEvent);
	// easy post of the user events throught this method
	virtual void postUserEvent(int code);
};
// extern declaration of the global function to access the app instance
extern SDLApp* getApp();

#endif // __SDL_APP_H__
