#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include "sdlapp.h"
#include "bmpfile.h"
#include "scrnctl.h"
#include "theGrid.h"

// constructor
Grid::Grid(int szX, int szY):CScreenControl(0,0,0,0)
{
	// initialize the dimensions of the mionefield
	sizeX = szX; 
	sizeY = szY;
	// allocate enought space fro the minefield and reveal arrays
	// clear them
	pMineField = new unsigned char[sizeX*sizeY];
	memset(pMineField, 0, sizeX*sizeY);
	pReveal = new unsigned char[sizeX*sizeY];
	memset(pReveal, 0, sizeX*sizeY);
	// initialise the state of the game
	eState = sWait;
	// the current item position
	indexX = indexY = -2;
	// in new game stae
	bNewGame = true;
} // constructor

// clear the minefiels and optinaly the visual representation of the field
void Grid::clear(bool all /*= true*/)
{
	// zero the memory of the monefield bomb counters
	memset(pMineField, 0, sizeX*sizeY);
	// optionally the visual state of each monefiled position also
	if (all)
		memset(pReveal, 0, sizeX*sizeY);
} // clear

// generate the 'bomb' numebr of mine sinto the mionefield
void Grid::Generate(int bombs)
{
	// update the state of the game to wait for user sctions
	eState = sWait;
	// clear only the minefield - 
	// to keep stete if the user has alredy marked any position in the minefield
	clear(false);
	// id the curent processed item is in the minefiled
	if (query(indexX, indexY)>= 0) 
	{
		// keep thet position untouched
		pMineField[indexX+indexY*sizeX] = 20;
	} else {
		// clear the focus state of the app
		getApp()->setFocus(NULL);
	}
	// generate all the bombs
	for (int i = 0; i < bombs; i++)
	{
		int minex = 0;
		int miney = 0;
		// try to generate ew positions until empty one is reached
		do {
			miney = rand()%sizeY;
			minex = rand()%sizeX;
		} while (pMineField[minex+miney*sizeX] != 0);
		// mark as 'bomb'
		pMineField[minex+miney*sizeX] = 10;
	} // for
	// if the user was hittin thet position
	// unmark it and coninue
	if (query(indexX, indexY)>= 0) 
		pMineField[indexX+indexY*sizeX] = 0;
} //Generate

// true if the mouse cursor is in the control area
int Grid::hittest(int x, int y)
{
	if ((xPos <= x) && (x < (xPos+wCtl)) && 
		(yPos <= y) && (y < (yPos+hCtl)))
		return true;
	return false;
} // hittest

// do Gameover
void Grid::gameOver()
{
	// lock the screen
	while(getApp()->scrlock() <0 );
	// get the minefiled images
	CImage image(pImages);
	// for each minefield position
	for (int j=0; j < sizeY; j++)
	{
		for (int i=0; i < sizeX; i++)
		{
			// compute the desination image locations
			int locX = xPos+i*image.getWidth();
			int locY = yPos+j*image.getHeight();
			// get the image index
			int index1 = pMineField[i+j*sizeX];
			// is it unrevealed and there is no bobm here
			if (pReveal[i+j*sizeX] == overUNV && index1 != 10)
			//  set the displayed indes to 'unhited bomb'
				index1 = 15;
			//is it marked
			if (pReveal[i+j*sizeX] == overMark)
			{
				// is it properly marked
				if (index1!= 10)
					index1 = 11;
				else
					index1 = 14;
			}
			// upadte the screen
			image.paint(CScreenControl::pGlobalDC->m_pBase, 
						CScreenControl::pGlobalDC->mapWidth, 
						CScreenControl::pGlobalDC->mapHeight, 
						locX, locY, index1
						);
		}
	}
	// unlock the screen and update the control area
	getApp()->scrunlock(this);
} // gameOver

// the repaint rioutine
void Grid::repaint()
{
	// get the minefield pictures
	CImage image(pImages);
	// for each position
	for (int j=0; j < sizeY; j++)
	{
		for (int i=0; i < sizeX; i++)
		{
			// compute the screen location
			int locX = xPos+i*image.getWidth();
			int locY = yPos+j*image.getHeight();
			int index1 = pMineField[i+j*sizeX];
			index1 = 15;

			image.paint(CScreenControl::pGlobalDC->m_pBase, 
						CScreenControl::pGlobalDC->mapWidth, 
						CScreenControl::pGlobalDC->mapHeight, 
						locX, locY, index1
						);
		}
	}
	// draw the 3 pixel wide 'bump' around
	bumpRect(xPos, yPos, wCtl, hCtl, 3);
	// draw the bump rect around the top controls(counters and the face button)
	bumpRect(xPos, 14, wCtl, 36, 3);
} // repaint

// recalc the number of the mines around each minefield position
void Grid::Recalc()
{
	// for each position
	for (int i = 0; i < sizeX; i++)
	{
		for (int j = 0; j < sizeY; j++)
		{
			// invoke the calcAround() routine
			pMineField[i+j*sizeX] = calcAround(i,j);
		}
	}
} // Recalc()

// calc the number of mines around the given minefield position
int Grid::calcAround(int i,int j)
{
	// if it is a mine return 10
	if (pMineField[i+j*sizeX] == 10)
		return 10;
	// for each around invoke compareMine() and accumulate the result
	return foreach(compareMine ,i,j);
} // calcAround

// return 1 if there is a mine at the minefiled location
int Grid::compareMine(int x, int y)
{
	return (int)(pMineField[(x)+(y)*sizeX] == 10);
} // compareMine

// return 1 if there is a mark at the minefiled location
int Grid::compareMark(int x, int y)
{
	return (int)(query(x, y) == overMark);
} // compareMark

// for each around iterator 
// invoke the fn member function for each valid location aroud the given one
// also accumulates the returned values and return thet value as result pf the functiuon
int Grid::foreach(memberFuncType func, int i, int j)
{
	// simply check and if not fail, invoke
	// acculunate teh results into the result variable
	int result = 0;	if (i > 0 && j > 0)
		result+= (this->*func)(i-1,j-1); //(pMineField[(i-1)+(j-1)*sizeX] == 10);

	if (i > 0 )
		result+=(this->*func)(i-1,j);//(pMineField[(i-1)+(j)*sizeX] == 10);
	
	if (i > 0 && j < (sizeY-1))
		result+=(this->*func)(i-1, j+1);//(pMineField[(i-1)+(j+1)*sizeX] == 10);
	
	if (j > 0)
		result+=(this->*func)(i,j-1);//(pMineField[(i)+(j-1)*sizeX] == 10);
	
	if (j < (sizeY-1))
		result+=(this->*func)(i,j+1);//(pMineField[(i)+(j+1)*sizeX] == 10);
	
	if (i <(sizeX-1) && j > 0)
		result+=(this->*func)(i+1,j-1);//(pMineField[(i+1)+(j-1)*sizeX] == 10);
	
	if (i <(sizeX-1))
		result+=(this->*func)(i+1,j);//(pMineField[(i+1)+(j)*sizeX] == 10);
	
	if (i <(sizeX-1) && j < (sizeY-1))
		result+=(this->*func)(i+1, j+1);//(pMineField[(i+1)+(j+1)*sizeX] == 10);

	// return the accumaualted result if someone cares of it :-)
	return result;
} //foreach

// is the mouse screen position is over the minefield and is the newly calculated indexes 
// differ from the last processed ones
bool Grid::queryCalcIndexes(int x, int y)
{
	CImage image(pImages);
	int newX = x / image.getWidth();
	int newY = y / image.getHeight();
	bool ret =  (newX != indexX || newY != indexY);
	return ret;
} //queryCalcIndexes

// calc the new item from the mouse screen position
// and set them to indexX and indexY member variables
void Grid::calcIndexes(int x, int y)
{
	CImage image(pImages);
	indexX = x / image.getWidth();
	indexY = y / image.getHeight();
	if (indexX < 0 || indexY < 0 || indexX >= sizeX || indexY >= sizeY)
	{
		indexX = indexY = - 2;
	}
} // calcIndexes()

// paint  the minefield item according to the curent visual state (pReveal[] array)
int Grid::paintIt(int i, int j)
{
	CImage image(pImages);
	// image destination localtion
	int locX = xPos+i*image.getWidth();
	int locY = yPos+j*image.getHeight();
	
	int index1 = 0;
	// get the queried position
	// ad match it againts the image indexes into the bitmap file
	switch (query(i,j))
	{
	case overUNV:
		index1 = 15;
		break;
	case overUNVdn:
		index1 = 0;
		break;
	case overQdn:
		index1 = 9;
		break;
	case overQ:
		index1 = 13;
		break;
	case overMark:
		index1 = 14;
		break;
	case overREV:
		index1 = pMineField[i+j*sizeX];
		break;
	default:
		return 0;
	}
	// lock the screen
	while (getApp()->scrlock() < 0);
	// paint the proper image at the calculated location
	image.paint(CScreenControl::pGlobalDC->m_pBase, 
				CScreenControl::pGlobalDC->mapWidth, 
				CScreenControl::pGlobalDC->mapHeight, 
				locX, locY, index1
				);
	// unlock and update the screen (only the affected part of the screen is processed)
	getApp()->scrunlock(locX, locY, image.getWidth(), image.getHeight());
	return 1;
} // paintIt

// e.g change the visual state of the lcation as the user pressed it
int Grid::exchangeIt(int i, int j)
{
	int index = nowhere;
	// check the state of the location
	switch (query(i,j))
	{
	case overUNV:
		// it is unrevealed so display is pressed
		index = overUNVdn;
		break;
	case overUNVdn:
		// over presed unrevealed location so depress it
		index = overUNV;
		break;
	case overQ:
		// over question mark so press the question mark
		index = overQdn;
		break;
	case overQdn:
		// over pressd question mark so depress it
		index = overQ;
		break;
	}
	// is there was a resonable change of the visual state
	if (index <0) return -1;
	// yes so change the visyual state
	pReveal[i+j*sizeX] = index;
	//return the index of the change made
	return index;
} //exchangeIt

// query the location visual state
int Grid::query(int i, int j)
{
	// is it not a valid lication then return
	if (i < 0 || j < 0 || i >= sizeX || j >= sizeY)
		return nowhere;
	// get the visual state at the location
	switch (pReveal[i+j*sizeX])
	{
	case overUNV:
		return overUNV;
	case overUNVdn:
		return overUNVdn;
	case overQ:
		return overQ;
	case overQdn:
		return overQdn;
	case overMark:
		return overMark;
	}// like the dummy bu it si more deskriptive then 'tricky' ones :-)
	return overREV;
} // query

// do rightclick action over the minefiled 
int Grid::rightClick()
{
	// query the visual state opf the (indexX, indexY) location
	switch (query(indexX, indexY))
	{
	case overUNV:
		// it is unrevealed so mark it
		pReveal[indexX+indexY*sizeX] = overMark;
		// notify the app so the mine counter to be updated
		getApp()->postUserEvent(SDLApp::evtMarkChange);
		return 0;
	case overMark:
		// it is over mak so make it a questionmark
		pReveal[indexX+indexY*sizeX] = overQ;
		// notify the app so the mine couter to be increased again
		getApp()->postUserEvent(SDLApp::evtMarkChangePlus);
		return 0;
	case overQ:
		// over the questionmark so meke it a clear unrevealed location again
		pReveal[indexX+indexY*sizeX] = overUNV;
		return 0;
	} // switch visual state of the location
	return 0;
} //rightClick

// do reveal of the location
int Grid::reveal(int x, int y)
{
	// check the localtion to be valid
	if (x<0 || y < 0 || x >= sizeX || y >= sizeY)
		return 0;
	// revealed or marked so rleavce is as is
	if ((pReveal[x+y*sizeX] == overREV) ||
		(pReveal[x+y*sizeX] == overMark))
		return 0;
	// game was over, exit
	if (eState == sGameOver)
		return 0;

	// make ir revealed
	pReveal[x+y*sizeX] = overREV;
	// check if it is a mine
	if (pMineField[x+y*sizeX] == 10)
	{
		// 'BOOM' and make the game over
		pMineField[x+y*sizeX] = 12;
		eState = sGameOver;
	}
	// update the screen by painting the location
	paintIt(x,y);
	// if it was clear then try to reveal recusemely all around it
	if (pMineField[x+y*sizeX] == 0)
		foreach(reveal, x, y);
	// retunr zero :-)))
	return 0;
} // reveal

// do processing the parsed user  action
// 1 means - left button was don and the it was up at the location pinted by indexX, indexY
// 2 the two mousbutton was pressed together and afterwards the one ot both was relesaed at
// location pointed by idexX, indexY 
void Grid::process(int action)
{
	switch (action)
	{
		// lBTUP - > hit that location
		case 1:
			if (bNewGame)
			{
				// we are in the new game state
				// generate the minefield
				bEnd = false;
				Generate(99);
				// recalc
				Recalc();
				bNewGame = false;
				// stert the timer
				getApp()->postUserEvent(getApp()->evtStartTimer);
			}
			// is it over the merket location
			if (pReveal[indexX+indexY*sizeX] == overMark)
				return;
			// is it was over the bomb/mine
			if (pMineField[indexX+indexY*sizeX] == 10)
			{
				pMineField[indexX+indexY*sizeX] = 12;
				pReveal[indexX+indexY*sizeX] = overREV;
				paintIt(indexX, indexY);
				// repaint nad end the game
				eState = sGameOver;
			} else
				// else reveal the localtion
				reveal(indexX,indexY);
			break;
		case 2:
			// do teh nest action as specified (reveal all around)
			foreach(reveal, indexX, indexY);
			break;
	}// end switch user actions
	//check the state
	if (eState == sGameOver || isEnd() == 1)
	{
		//game si over
		getApp()->setFocus(NULL);
		gameOver();
		eState = sGameOver;
		bEnd = (isEnd() == 1);
		// stop the timer
		getApp()->postUserEvent(getApp()->evtStopTimer);
		//say click to the app
		getApp()->onClick(this);
	}  // if
} // process()

// compute the endof the game when the user reveal all the marks sucesfuly
bool Grid::isEnd()
{
	int count = 0;
	for (int i = 0; i < sizeX*sizeY; i++)
	{
		if (pReveal[i] == overREV)
			count++;
	}
	return count == sizeX*sizeY - 99;
} // isEnd


// process user input -> LPuttonDown event
void Grid::onLButtonDown(int x, int y, unsigned char flags)
{
	// images
	CImage image(pImages);
	//query the current game state
	switch (eState)
	{
	case sWait:
		// we are waitiin for user input
		// grab the focus to us
		getApp()->setFocus(this);
		// chane to the state where the left button is down
		eState = sLBDown;
		// calc the indexX, indexY - > current item to be processed
		calcIndexes(x,y);
		// press it down(change the visual state)
		exchangeIt(indexX, indexY);
		// repaint it
		paintIt(indexX, indexY);
		// chane the funny face to say 'o'
		getApp()->postUserEvent(getApp()->evtFaceO);
	break;
	case sRdn:
	case sRBDown:
		// right button is already down
		// recalc the curent intel location
		calcIndexes(x-xPos, y-yPos);
		//if (eState == sRdn)
		{
			// change the state 
			exchangeIt(indexX, indexY);
			// repaint it
			paintIt(indexX, indexY);
		}
		// do for each around the current location the same
		foreach(exchangeIt, indexX, indexY);
		foreach(paintIt, indexX, indexY);
		// change the state of the game to 'two mouse buttown are down'
		eState = sLR;
		// chane the funny smile buuton to say 'o'
		getApp()->postUserEvent(getApp()->evtFaceO);
		break;
	case sGameOver:
		{
			// game was over
			int i = 5*10;
		}
		break;
	}
} //onLButtonDown

// process the mouse movement events
void Grid::onMouseMove(int x, int y, unsigned char flags)
{
	// is the game si over
	if (eState == sGameOver)
		return;
	// are we heve the focus
	if (getApp()->getFocus() != this) 
	{
		// no! is the game over
		if (eState == sGameOver)
			return;
		// no then wait for next user actions
		eState = sWait;
		return;
	}
	// are we awit for user actions
	if (eState == sWait)
	{
		// clear any focus and return
		getApp()->setFocus(NULL);
		return;
	}
	// is there new minefield location pointed by the mouse?
	if (!queryCalcIndexes(x - xPos, y - yPos))
		return;
	// get images
	CImage image(pImages);
	switch (eState)
	{
	case sWait: 
	case sRBDown:
		// if it is a wait or only rbutton is down - do nothing
		break;
	case sLBDown:
		// we have lleft mouse button down
		// depress the old location
		exchangeIt(indexX, indexY);
		// repaint it
		paintIt(indexX, indexY);
		// calc then ne location by he mouse position
		calcIndexes(x - xPos, y - yPos);
		// press it
		exchangeIt(indexX, indexY);
		// and finally repaint 
		paintIt(indexX, indexY);
		break;
	case sLR:
		// we have the two mouse button down
		// so depress the active location
		exchangeIt(indexX, indexY);
		// and repaint
		paintIt(indexX, indexY);
		// also do the same for all thet surround it
		foreach(exchangeIt, indexX, indexY);
		// also repaint them
		foreach(paintIt, indexX, indexY);
		// calc the new location
			calcIndexes(x - xPos, y -yPos);
		// press and repaint it
		exchangeIt(indexX, indexY);
		paintIt(indexX, indexY);
		// press all around the active location and repint them
		foreach(exchangeIt, indexX, indexY);
		foreach(paintIt, indexX, indexY);
		break;
	} // switch(game state)
} // onMouseMove

// process user input
void Grid::onLButtonUp(int x, int y, unsigned char flags)
{
	// are we have the focus if not then return
	if (getApp()->getFocus() != this) return;
	// get the images
	CImage image(pImages);
	// check the game state
	switch (eState)
	{
	case sLBDown:
		// we have the left button down
		// go to wait for user actions state
		eState = sWait;
		// depress the old item and repaint it
		exchangeIt(indexX, indexY);
		paintIt(indexX, indexY);
		// calc the new location
		calcIndexes(x - xPos, y - yPos);
		// process the user action - - user click over the minefield
		process(1);
		// release the focus
		getApp()->setFocus(NULL);
		// id the game is over?
		if (eState != sGameOver)
			// no, then retur the face button back to smile
			getApp()->postUserEvent(getApp()->evtFaceBack);
		break;
	case sLR:
		// we have the tqo mouse buttons down
		// depress and repaint the old item
		exchangeIt(indexX, indexY);
		paintIt(indexX, indexY);
		// also depress and repaint all around it
		foreach(exchangeIt, indexX, indexY);
		foreach(paintIt, indexX, indexY);
		// calc the new location
		calcIndexes(x-xPos,y-yPos);
		// are we over revealed item and are the number of marked locations arrount it 
		// is the ssame as the numer of calculated arount it?
		if ((query(indexX, indexY) == overREV) &&
		(foreach(compareMark, indexX, indexY) == pMineField[indexX+indexY*sizeX]))
		{
			// yes! go to wait state
			eState = sWait;
			// release the focus
			getApp()->setFocus(NULL);
			// process the event: user tryes to reveal all around the current location and it 
			// is shure thet all is marked corectly
			process(2);
		}else {
			// otherwise go to state: right button is down
			eState = sRdn;
		} // if 
		// are the game is over. if not restore the face button to showe the smile
		if (eState != sGameOver)
			getApp()->postUserEvent(getApp()->evtFaceBack);
		break;
	case sLdn:
		// we have only left button down and previously the two buttons was down
			eState = sWait;
			// wait for user input and release the focus
			getApp()->setFocus(NULL);
		break;
	} // switch
} // onLButtonUp

// process the mouse even : Right button down
void Grid::onRButtonDown(int x, int y, unsigned char flags)
{
	// check the game state
	switch (eState)
	{
	case sWait:
		// we are waiting for user input
		// go to staet: right button is down
		eState = sRBDown;
		// calc the current item location from the mouse position
		calcIndexes(x, y);
		// process the RightClick action(mark if not marked, ? if is marked 
		// or clear all marks over the location: depending on the visual state of the location)
		rightClick();
		// repaint thge location
		paintIt(indexX, indexY);
		// set the focus to me
		getApp()->setFocus(this);
		break;
	case sLdn:
	case sLBDown:
		// left button is down
		// so calc the location
		calcIndexes(x-xPos,y-yPos);
		// if tpreviouse we have the two mouse buttons down
		if (eState == sLdn)
		{
			// just press it and repaint
			exchangeIt(indexX, indexY);
			paintIt(indexX, indexY);
		}
		// press all arount the current location and repaint
		foreach(exchangeIt, indexX, indexY);
		foreach(paintIt, indexX, indexY);
		// go to state: two mouse buttons are down
		eState = sLR;
		break;
	}// switch
} // onRButtonDown

// process teh mouse event: Right mouse button up
void Grid::onRButtonUp(int x, int y, unsigned char flags)
{
	// check the game state
	switch (eState)
	{
	case sLR:
		// we have two mouse buttons down
		// depress and repaint all items around the old locatin includeing the it
		exchangeIt(indexX, indexY);
		paintIt(indexX, indexY);
		foreach(exchangeIt, indexX, indexY);
		foreach(paintIt, indexX, indexY);
		// calc the new active location
		calcIndexes(x-xPos,y-yPos);
		// are the event occurs over the revealed location
		// and are that location is surounded by the exact number of marked locations 
		// as thouse calculated when Recalc() was invoked
		if ((query(indexX, indexY) == overREV) &&
		(foreach(compareMark, indexX, indexY) == pMineField[indexX+indexY*sizeX]))
		{
			// yes! go to wait state
			eState = sWait;
			// release the focus
			getApp()->setFocus(NULL);
			// precess the action (user try to reveal all the is not marked around the current location)
			process(2);
		} else
			// when the above test fail. go to state when only left mouse button is down
			// ant we war in two mouse buttons down state
			eState = sLdn;
		break;
	case sRBDown:
	case sLdn:
	case sRdn:
		// if we are in any other stae, bring us to wait state and optinally release the focus
		eState = sWait;
		getApp()->setFocus(NULL);
		break;
	} // switch()
} // onRButtonUp





