#ifndef __THE_GRID_H__
#define __THE_GRID_H__

// class grid - draws and manipulates the mine filed in th egame
class Grid : public CScreenControl 
{
public:
	// the grid/ minefield dimensions
	int sizeX;
	int sizeY;
	// array to the minefield data - this array is initialized
	// in the Recalc() to keep th enumber of the mines around the given minefield position
	unsigned char* pMineField;
	// the state of the minefield position 
	// revealed, marked, questinmarked queried and so on
	// just the curent visual representation of the minefield
	unsigned char* pReveal;
	// flag to indicate that new game is in progress
	// this flag is scande and if it is set then at first
	// lbutton down event the entire minefield is generated and recalculated
	// excluding the hited position so the avoid hiting the mine at the initial hit
	// of the user
	bool bNewGame;
	// images that hold the minefiled pictures(colorfil digits, mones, marks...)
	CBMPFile* pImages;
	// flag that indikate the gameover is in progress determininf the success fail state
	bool bEnd;
	// internal state of the cirent game
	// short description:
	// sWait	-> game is in idel tstate waitin for th euser actions
	// sLBDown	-> user holds left mouse button
	// sRBDown	-> user holds right mouse button
	// sLR		-> user holds left and right mouse buttons
	// sLdn		-> user was holding the two mouse buttons but now holds only the LEFT one
	// sRdn		-> user was holding the two mouse buttons but now holds only the RIGHT one
	// sNewGame -> the game is in the NewGame state waiting for the first lbutton down
	//			event to generate and recalculate the minefield
	// sGameOver-> the game over state
	enum {sWait=0, sLBDown, sRBDown, sLR, sLdn, sRdn, sNewGame, sGameOver}
	eState;
	// various visual states of the minefield position
	// nowhere	-> ouside of the minefield
	// overUNV	-> over the unveiled position
	// overUNVdn-> unveiled bud in the down state(queried/pressed state)
	// overQ	-> the question mark
	// overQdn	-> question mark pressed down
	// overMark -> the marked position
	// overREV	-> revealed position -> show the numbers of the mines around the position
	enum {nowhere = -1, overUNV, overUNVdn, overQ, overQdn, overMark, overREV}
	eQuery;
	// gurent processed position
	int indexX, indexY;

	// constructor
	Grid(int szX, int szY);

	// clear the minefield and/or reveal states  depending of the all parameter
	void clear(bool all = true);
	// generate 'bomb' count mines in the minefield // if the (indexX, indexY) is  valid mainefiled 
	// position preserve it as empty
	void Generate(int bombs);
	// typedef the pointer to member funtion returning int and having two ints as parameters
	// this is a type for all functions that can be passed as arguments in foreach method
	typedef int (Grid:: *memberFuncType)(int x, int y);
	// for each 'cell' around the i,j mionefiled position 
	// execute the member function pointed by fn -> accumulate the result and 
	// return it
	// the function check for boundary violations and skip all positions outside of the grid
	int foreach(memberFuncType fn, int i, int j);
	// return true if the x,y position si over the mine
	int compareMine(int x, int y);
	// return true if (x,y) position is over the mark
	int compareMark(int x, int y);
	// calc the number of mines around the given minefield position
	int calcAround(int i,int j);
	// recalc the minefiled positions to hold the number of the mines around each of them
	void Recalc();
	// do gameOver
	virtual void gameOver();
	// id the (x,y) position is inside the minefield boundary
	bool queryCalcIndexes(int x, int y);
	// calc the x and y positions  given the mouse coordinates(in client coords)
	void calcIndexes(int x, int y);
	// visual representation of the minefiled item at (i,j) position
	int paintIt(int i, int j);
	// e.g. pres the item(when the lbutton is down or when the two buttons are pressed together
	int exchangeIt(int i, int j);
	// query the visual representation of the minefield position (i,j)
	// return -1 if outside otehrwice 
	int query(int i, int j);	
	// do right click at specified pisition
	int rightClick();
	// reveal the desired minefield position
	int reveal(int x, int y);
	// process user action (1 : left button click; 2 : two button at revealed location where 
	// number of unrevealed items is equal to the number of the items alculated for it
	void process(int action);
	// compute the end of game status: number of unrevealed items is equal to the number 
	// of mines left to be uncover
	bool isEnd();
	// hitest for the grid control
	virtual int hittest(int x, int y);
	// repaint the entire minefield
	virtual void repaint();
	//various mouse event handlers
	virtual void onLButtonDown(int x, int y, unsigned char flags);
	virtual void onMouseMove(int x, int y, unsigned char flags);
	virtual void onLButtonUp(int x, int y, unsigned char flags);
	virtual void onRButtonDown(int x, int y, unsigned char flags);
	virtual void onRButtonUp(int x, int y, unsigned char flags);
};

#endif //__THE_GRID_H__