# sdl2-compat CMake configuration file:
# This file is meant to be placed in a cmake subfolder of sdl2-compat-devel-2.32.60-VC.zip

cmake_minimum_required(VERSION 3.0...3.28)

include(FeatureSummary)
set_package_properties(SDL2 PROPERTIES
    URL "https://www.libsdl.org/"
    DESCRIPTION "low level access to audio, keyboard, mouse, joystick, and graphics hardware"
)

# Copied from `configure_package_config_file`
macro(set_and_check _var _file)
    set(${_var} "${_file}")
    if(NOT EXISTS "${_file}")
        message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
    endif()
endmacro()

# Copied from `configure_package_config_file`
macro(check_required_components _NAME)
    foreach(comp ${${_NAME}_FIND_COMPONENTS})
        if(NOT ${_NAME}_${comp}_FOUND)
            if(${_NAME}_FIND_REQUIRED_${comp})
                set(${_NAME}_FOUND FALSE)
            endif()
        endif()
    endforeach()
endmacro()

set(SDL2_FOUND TRUE)

if(SDL_CPU_X86)
    set(_sdl_arch_subdir "x86")
elseif(SDL_CPU_X64 OR SDL_CPU_ARM64EC)
    set(_sdl_arch_subdir "x64")
elseif(SDL_CPU_ARM64)
    set(_sdl_arch_subdir "arm64")
else()
    set(SDL2_FOUND FALSE)
    return()
endif()

get_filename_component(_sdl2_prefix "${CMAKE_CURRENT_LIST_DIR}/.." ABSOLUTE)
set_and_check(SDL2_PREFIX      "${_sdl2_prefix}")
unset(_sdl2_prefix)

set_and_check(SDL2_EXEC_PREFIX  "${SDL2_PREFIX}")
set_and_check(SDL2_INCLUDE_DIR  "${SDL2_PREFIX}/include")
set(SDL2_INCLUDE_DIRS           "${SDL2_INCLUDE_DIR}")
set_and_check(SDL2_BINDIR       "${SDL2_PREFIX}/lib/${_sdl_arch_subdir}")
set_and_check(SDL2_LIBDIR       "${SDL2_PREFIX}/lib/${_sdl_arch_subdir}")

set(SDL2_LIBRARIES      SDL2::SDL2main SDL2::SDL2)
set(SDL2MAIN_LIBRARY    SDL2::SDL2main)
set(SDL2TEST_LIBRARY    SDL2::SDL2test)

set(_sdl2_implib      "${SDL2_LIBDIR}/SDL2.lib")
set(_sdl2_dll         "${SDL2_LIBDIR}/SDL2.dll")
set(_sdl2test_lib     "${SDL2_LIBDIR}/SDL2_test.lib")
set(_sdl2main_lib     "${SDL2_LIBDIR}/SDL2main.lib")

unset(_sdl_arch_subdir)

# All targets are created, even when some might not be requested though COMPONENTS.
# This is done for compatibility with CMake generated SDL2-target.cmake files.

if(EXISTS "${_sdl2_implib}" AND EXISTS "${_sdl2_dll}")
    if(NOT TARGET SDL2::SDL2)
        add_library(SDL2::SDL2 SHARED IMPORTED)
        set_target_properties(SDL2::SDL2
            PROPERTIES
                INTERFACE_INCLUDE_DIRECTORIES "${SDL2_INCLUDE_DIRS}"
                IMPORTED_IMPLIB "${_sdl2_implib}"
                IMPORTED_LOCATION "${_sdl2_dll}"
                COMPATIBLE_INTERFACE_BOOL "SDL2_SHARED"
                INTERFACE_SDL2_SHARED "ON"
                COMPATIBLE_INTERFACE_STRING "SDL_VERSION"
                INTERFACE_SDL_VERSION "SDL2"
        )
    endif()
    set(SDL2_SDL2_FOUND TRUE)
else()
  set(SDL2_SDL2_FOUND FALSE)
endif()
unset(_sdl2_implib)
unset(_sdl2_dll)

set(SDL2_SDL2-static_FOUND FALSE)

if(EXISTS "${_sdl2test_lib}")
    if(NOT TARGET SDL2::SDL2_test)
        add_library(SDL2::SDL2_test STATIC IMPORTED)
        set_target_properties(SDL2::SDL2_test
            PROPERTIES
                INTERFACE_INCLUDE_DIRECTORIES "${SDL2_INCLUDE_DIRS}"
                IMPORTED_LOCATION "${_sdl2test_lib}"
                COMPATIBLE_INTERFACE_STRING "SDL_VERSION"
                INTERFACE_SDL_VERSION "SDL2"
        )
    endif()
    set(SDL2_SDL2_test_FOUND TRUE)
else()
    set(SDL2_SDL2_test_FOUND FALSE)
endif()
unset(_sdl2test_lib)

if(EXISTS "${_sdl2main_lib}")
    if(NOT TARGET SDL2::SDL2main)
        add_library(SDL2::SDL2main STATIC IMPORTED)
        set_target_properties(SDL2::SDL2main
            PROPERTIES
                IMPORTED_LOCATION "${_sdl2main_lib}"
                COMPATIBLE_INTERFACE_STRING "SDL_VERSION"
                INTERFACE_SDL_VERSION "SDL2"
        )
    endif()
    set(SDL2_SDL2main_FOUND TRUE)
else()
    set(SDL2_SDL2main_FOUND FALSE)
endif()
unset(_sdl2main_lib)

function(_sdl_create_target_alias_compat NEW_TARGET TARGET)
  if(CMAKE_VERSION VERSION_LESS "3.18")
    # Aliasing local targets is not supported on CMake < 3.18, so make it global.
    add_library(${NEW_TARGET} INTERFACE IMPORTED)
    set_target_properties(${NEW_TARGET} PROPERTIES INTERFACE_LINK_LIBRARIES "${TARGET}")
  else()
    add_library(${NEW_TARGET} ALIAS ${TARGET})
  endif()
endfunction()

if(SDL2_SDL2_FOUND)
  set(SDL2_FOUND TRUE)
endif()

check_required_components(SDL2)
